/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptodev.driver.chipmanager;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.cryptodev.CryptoDevFactory;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.cryptodev.driver.IDevDriver;
import com.xdja.cryptodev.driver.chipmanager.ChipManagerKey;
import com.xdja.cryptodev.driver.xdja.XdjaDevExtraInfo;
import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.jniapi.JarMultiJniApiManager;
import com.xdja.multichip.jniapi.JarMultiJniApiVhsmManager;
import com.xdja.multichip.param.JniApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010!\u001a\u00020\tH\u0016J\u0012\u0010\"\u001a\u00020\u00152\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J*\u0010#\u001a\u00020 2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010&\u001a\u00020\tH\u0016J\b\u0010'\u001a\u00020\u0015H\u0016J\b\u0010(\u001a\u00020\u0015H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/xdja/cryptodev/driver/chipmanager/ChipManagerDriver;", "Lcom/xdja/cryptodev/driver/IDevDriver;", "Lcom/xdja/multichip/jniapi/JarMultiChipStatusManager$MultiChipStatusListener;", "()V", "ChipManagerExistAction", "", "ChipManagerProcessSuffixs", "", "WaitChipManagerExistTimeMS", "", "context", "Landroid/content/Context;", "driverName", "getDriverName", "()Ljava/lang/String;", "jniApiManager", "Lcom/xdja/multichip/jniapi/JarMultiJniApiManager;", "kotlin.jvm.PlatformType", "sdcardReceiver", "Landroid/content/BroadcastReceiver;", "chipAdd", "", "cardId", "type", "chipRemove", "cleanChipManagerOldProcess", "createInstance", "Lcom/xdja/cryptodev/devapi/CryptoInstance;", "devInfo", "Lcom/xdja/cryptodev/CryptoDevInfo;", "destroy", "hasChipManagerOldProcess", "", "init", "killOtherProcess", "loopMake", "isRetry", "cardType", "refresh", "serviceDeath", "serviceStart", "typeCovert", "Lcom/xdja/cryptodev/CryptoDevType;", "cmType", "Companion", "crypto_release"})
public final class ChipManagerDriver
extends IDevDriver
implements JarMultiChipStatusManager.MultiChipStatusListener {
    private Context context;
    private final BroadcastReceiver sdcardReceiver;
    private final JarMultiJniApiManager jniApiManager = JarMultiJniApiManager.getInstance();
    private final List<String> ChipManagerProcessSuffixs = CollectionsKt.listOf((Object[])new String[]{"covercard", "boardchip", "tfkey", "vhsm", "bluekey", "tfkey"});
    private final int WaitChipManagerExistTimeMS = 500;
    private final String ChipManagerExistAction = "com.xdja.multichip.process.exits";
    @NotNull
    public static final String driverName = "ChipManagerDriver";
    @NotNull
    public static final String DRIVER_NAME = "ChipManagerDriver";
    private static final String THIS_FILE = "ChipManagerDriver";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getDriverName() {
        return "ChipManagerDriver";
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasChipManagerOldProcess(Context context) {
        Object v2;
        block3: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.ChipManagerProcessSuffixs;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = context.getPackageName() + ':' + (String)it;
                collection.add(string2);
            }
            List chipManagerProcessList = (List)destination$iv$iv;
            Object object = context.getSystemService("activity");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
            }
            ActivityManager activityManager = (ActivityManager)object;
            List list = activityManager.getRunningAppProcesses();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"activityManager.runningAppProcesses");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ActivityManager.RunningAppProcessInfo it = (ActivityManager.RunningAppProcessInfo)element$iv;
                boolean bl = false;
                if (!chipManagerProcessList.contains(it.processName)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        ActivityManager.RunningAppProcessInfo item = v2;
        return item != null;
    }

    public final void cleanChipManagerOldProcess(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        boolean bl = false;
        boolean bl2 = false;
        Context $this$with = context;
        boolean bl3 = false;
        if (this.hasChipManagerOldProcess($this$with)) {
            Intent intent = new Intent(this.ChipManagerExistAction);
            Context context2 = $this$with;
            boolean bl4 = false;
            boolean bl5 = false;
            Intent $this$apply = intent;
            boolean bl6 = false;
            $this$apply.setPackage($this$with.getPackageName());
            Intent intent2 = intent;
            context2.sendBroadcast(intent2);
            Thread.sleep(this.WaitChipManagerExistTimeMS);
        }
    }

    @Override
    public int init() {
        Context context = this.context = CryptoDevManager.Companion.getInstance().getContext();
        if (context == null) {
            Intrinsics.throwNpe();
        }
        this.cleanChipManagerOldProcess(context);
        Log.d((String)"ChipManagerDriver", (String)"Resiger chip status listener");
        JarMultiChipStatusManager.getInstance().registerListener(this.context, this);
        this.refresh();
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public synchronized int refresh() {
        block15: {
            Pair<Integer, List<JniApiParam>> all;
            int ret;
            block14: {
                ret = 0;
                this.getDevInfos().clear();
                Pair<Integer, List<JniApiParam>> pair = this.jniApiManager.getAll(this.context);
                Intrinsics.checkExpressionValueIsNotNull(pair, (String)"jniApiManager.getAll(context)");
                all = pair;
                Integer n = (Integer)all.first;
                if (n != null && n == 0) break block14;
                Log.e((String)"ChipManagerDriver", (String)("Get devices error. ret " + (Integer)all.first));
                break block15;
            }
            for (JniApiParam param : (List)all.second) {
                CryptoDevInfo devInfo;
                block13: {
                    Pair<Integer, JarJniApiProxy> jniProxyPair;
                    block16: {
                        devInfo = new CryptoDevInfo();
                        if (param.chipType == 1 && !TextUtils.isEmpty((CharSequence)param.other)) {
                            Integer xdjaType;
                            Integer n = xdjaType = Integer.valueOf(param.other);
                            int n2 = 531;
                            if (n != null && n == n2) {
                                String string = Build.DISPLAY;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Build.DISPLAY");
                                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"ZTE C2017", (boolean)false, (int)2, null)) {
                                    param.chipType = 2;
                                }
                            }
                        }
                        if (param.chipType == 32) {
                            devInfo.setPrivateData(new XdjaDevExtraInfo().setType(32));
                        }
                        devInfo.setType(this.typeCovert(param.chipType));
                        String string = param.cardId;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"param.cardId");
                        devInfo.setCardId(string);
                        devInfo.setDriver(this.getDriverName());
                        jniProxyPair = null;
                        jniProxyPair = this.jniApiManager.make(this.context, devInfo.getCardId());
                        Integer n = (Integer)jniProxyPair.first;
                        if (n == null || n != 0) break block16;
                        JarJniApiProxy proxy = (JarJniApiProxy)jniProxyPair.second;
                        XDJA_DEVINFO xdja_devinfo = new XDJA_DEVINFO();
                        ret = proxy.GetDevInfo(xdja_devinfo);
                        if (ret == 0) {
                            if (xdja_devinfo.cardtype == 2304) {
                                devInfo.setFactory(CryptoDevFactory.FACTORY_HAISI);
                                break block13;
                            } else {
                                devInfo.setFactory(CryptoDevFactory.FACTORY_XDJA);
                            }
                            break block13;
                        } else {
                            Log.e((String)"ChipManagerDriver", (String)("Card " + devInfo.getCardId() + " get dev info faild. Error " + ret));
                            continue;
                        }
                    }
                    Log.e((String)"ChipManagerDriver", (String)("Card " + devInfo.getCardId() + " make failed. Error " + (Integer)jniProxyPair.first));
                    continue;
                }
                Log.d((String)"ChipManagerDriver", (String)("Add device  " + devInfo));
                this.getDevInfos().add(devInfo);
            }
        }
        if (CryptoDevManager.Companion.getInstance().isDisableSoft()) return super.refresh();
        Pair<Integer, JarJniApiProxy> vs = this.jniApiManager.make(this.context, 16);
        JarJniApiProxy proxy = (JarJniApiProxy)vs.second;
        XdjaDevExtraInfo extraInfo = new XdjaDevExtraInfo();
        Integer n = (Integer)vs.first;
        if (n == null || n != 0 || proxy == null) {
            Pair<Integer, Pair<JniApiParam, JarJniApiProxy>> defaultVhsm = JarMultiJniApiVhsmManager.getInstance().createDefaultVhsm(this.context);
            if (defaultVhsm.second == null) return super.refresh();
            Object object = defaultVhsm.second;
            if (object == null) {
                Intrinsics.throwNpe();
            }
            JarJniApiProxy jniApiProxy = (JarJniApiProxy)((Pair)object).second;
            Integer n3 = (Integer)defaultVhsm.first;
            if (n3 == null) {
                return super.refresh();
            }
            if (n3 != 0) return super.refresh();
            if (jniApiProxy == null) return super.refresh();
            CryptoDevInfo devInfo = new CryptoDevInfo();
            CryptoDevType cryptoDevType = this.typeCovert(jniApiProxy.getCardType());
            devInfo.setType(cryptoDevType);
            Object object2 = jniApiProxy.getCardId().second;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"jniApiProxy.cardId.second");
            devInfo.setCardId((String)object2);
            devInfo.setDriver(this.getDriverName());
            devInfo.setFactory(CryptoDevFactory.FACTORY_XDJA);
            Pair<Integer, JarJniApiProxy> vs1 = this.jniApiManager.make(this.context, 16);
            this.getDevInfos().add(devInfo);
            return super.refresh();
        }
        CryptoDevInfo devInfo = new CryptoDevInfo();
        CryptoDevType cryptoDevType = this.typeCovert(proxy.getCardType());
        devInfo.setType(cryptoDevType);
        if (cryptoDevType == CryptoDevType.DEV_TYPE_Soft) {
            devInfo.setPrivateData(extraInfo.setType(extraInfo.getXDJA_VHSM()));
        }
        Object object = proxy.getCardId().second;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"proxy.cardId.second");
        devInfo.setCardId((String)object);
        devInfo.setDriver(this.getDriverName());
        devInfo.setFactory(CryptoDevFactory.FACTORY_XDJA);
        this.getDevInfos().add(devInfo);
        return super.refresh();
    }

    @Override
    @Nullable
    public CryptoInstance createInstance(@NotNull CryptoDevInfo devInfo) {
        Intrinsics.checkParameterIsNotNull((Object)devInfo, (String)"devInfo");
        CryptoInstance dev = new ChipManagerKey(this, devInfo);
        this.getCryptoDevs().add(dev);
        return dev;
    }

    private final CryptoDevType typeCovert(int cmType) {
        CryptoDevType cryptoDevType;
        switch (cmType) {
            case 2: {
                cryptoDevType = CryptoDevType.DEV_TYPE_SdCard;
                break;
            }
            case 1: {
                cryptoDevType = CryptoDevType.DEV_TYPE_Chip;
                break;
            }
            case 4: {
                cryptoDevType = CryptoDevType.DEV_TYPE_BlueTooth;
                break;
            }
            case 8: {
                cryptoDevType = CryptoDevType.DEV_TYPE_SimKey;
                break;
            }
            case 16: 
            case 32: {
                cryptoDevType = CryptoDevType.DEV_TYPE_Soft;
                break;
            }
            default: {
                cryptoDevType = CryptoDevType.DEV_TYPE_Chip;
            }
        }
        return cryptoDevType;
    }

    @Override
    public void destroy() {
        JarMultiChipStatusManager.getInstance().unregisterListener(this);
        this.killOtherProcess(this.context);
        try {
            Log.e((String)"ChipManagerDriver", (String)"Kill chipmanager process. Need wait 1.2 seconds");
            Thread.sleep(1200L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        super.destroy();
    }

    private final void killOtherProcess(Context context) {
        try {
            Context context2 = context;
            if (context2 == null) {
                Intrinsics.throwNpe();
            }
            PackageManager pm = context2.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 4);
            HashMap mapList = new HashMap();
            for (ServiceInfo info : pi.services) {
                if (mapList.containsKey(info.processName)) {
                    Object v = mapList.get(info.processName);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    ((ArrayList)v).add(info.name);
                    continue;
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add(info.name);
                Map map = mapList;
                String string = info.processName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"info.processName");
                map.put(string, list);
            }
            Object object = context.getSystemService("activity");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
            }
            ActivityManager am = (ActivityManager)object;
            List runingProcessInfo = am.getRunningAppProcesses();
            for (ActivityManager.RunningAppProcessInfo info : runingProcessInfo) {
                if (info.pid == Process.myPid() || Arrays.binarySearch(info.pkgList, context.getPackageName()) < 0) continue;
                if (mapList.containsKey(info.processName)) {
                    Object v = mapList.get(info.processName);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    for (String serviceName : (ArrayList)v) {
                        Intent intent = new Intent();
                        intent.setClassName(context.getPackageName(), serviceName);
                        context.stopService(intent);
                    }
                }
                Process.killProcess((int)info.pid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void chipAdd(@NotNull String cardId, int type) {
        boolean needRetry;
        CryptoDevInfo devInfo;
        Intrinsics.checkParameterIsNotNull((Object)cardId, (String)"cardId");
        Log.d((String)"ChipManagerDriver", (String)("ChipAdd---------------------->\u5361\u53f7\uff1a" + cardId + ", \u7c7b\u578b\uff1a" + type));
        if (TextUtils.isEmpty((CharSequence)cardId)) {
            Log.e((String)"ChipManagerDriver", (String)"ChipManager device added, but Empty card id!!!");
            return;
        }
        Iterator<CryptoDevInfo> iterator = this.getDevInfos().iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"devInfos.iterator()");
        Iterator<CryptoDevInfo> devIter = iterator;
        while (devIter.hasNext()) {
            devInfo = devIter.next();
            if (!Intrinsics.areEqual((Object)devInfo.getCardId(), (Object)cardId)) continue;
            Log.d((String)"ChipManagerDriver", (String)("Device id " + cardId + " already in devlist"));
            return;
        }
        devInfo = new CryptoDevInfo();
        devInfo.setType(this.typeCovert(type));
        devInfo.setCardId(cardId);
        devInfo.setDriver(this.getDriverName());
        boolean bl = needRetry = this.loopMake(this.context, false, type, devInfo);
        if (bl) {
            for (int maxCount = 10; maxCount > 0 && needRetry; --maxCount) {
                Log.d((String)"ChipManagerDriver", (String)"WANGHAO-------into the fucking loop");
                Thread.sleep(1000L);
                needRetry = this.loopMake(this.context, true, type, devInfo);
            }
        } else {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean loopMake(Context context, boolean isRetry, int cardType, CryptoDevInfo devInfo) {
        Integer result;
        block15: {
            block14: {
                block11: {
                    block13: {
                        block12: {
                            Pair<Integer, JarJniApiProxy> pair;
                            JarMultiJniApiManager jniApiManager = JarMultiJniApiManager.getInstance();
                            Pair<Integer, JarJniApiProxy> jniProxyPair = null;
                            if (isRetry) {
                                Pair<Integer, JarJniApiProxy> pair2 = jniApiManager.make(context, cardType);
                                pair = pair2;
                                Intrinsics.checkExpressionValueIsNotNull(pair2, (String)"jniApiManager.make(context, cardType)");
                            } else {
                                Pair<Integer, JarJniApiProxy> pair3 = jniApiManager.make(context, devInfo.getCardId());
                                pair = pair3;
                                Intrinsics.checkExpressionValueIsNotNull(pair3, (String)"jniApiManager.make(context, devInfo.cardId)");
                            }
                            jniProxyPair = pair;
                            Integer n = result = (Integer)jniProxyPair.first;
                            if (n == null || n != 0) break block11;
                            JarJniApiProxy proxy = (JarJniApiProxy)jniProxyPair.second;
                            XDJA_DEVINFO xdjaDevinfo = new XDJA_DEVINFO();
                            result = proxy.GetDevInfo(xdjaDevinfo);
                            if (result == 0) {
                                if (xdjaDevinfo.cardtype == 2304) {
                                    devInfo.setFactory(CryptoDevFactory.FACTORY_HAISI);
                                } else {
                                    devInfo.setFactory(CryptoDevFactory.FACTORY_XDJA);
                                }
                                this.getDevInfos().add(devInfo);
                                Log.d((String)"ChipManagerDriver", (String)("Add device  " + devInfo));
                                Log.d((String)"ChipManagerDriver", (String)("Dev list size " + this.getDevInfos().size()));
                                this.deviceAdded(devInfo);
                                return false;
                            }
                            int n2 = -10001;
                            if (result == n2) break block12;
                            n2 = -10003;
                            if (result == n2) break block12;
                            n2 = -10002;
                            if (result != n2) break block13;
                        }
                        Log.e((String)"ChipManagerDriver", (String)("--retry GetDevInfo-------error:----" + result));
                        return true;
                    }
                    Log.e((String)"ChipManagerDriver", (String)("--break GetDevInfo-------error:----" + result));
                    return false;
                }
                Integer n = result;
                int n3 = -10001;
                if (n != null && n == n3) break block14;
                Integer n4 = result;
                n3 = -10003;
                if (n4 != null && n4 == n3) break block14;
                Integer n5 = result;
                n3 = -10002;
                if (n5 == null || n5 != n3) break block15;
            }
            Log.e((String)"ChipManagerDriver", (String)("--retry make-------error:----" + result));
            return true;
        }
        Log.e((String)"ChipManagerDriver", (String)("--break make-------error:----" + result));
        return false;
    }

    @Override
    public synchronized void chipRemove(int type) {
        Iterator<CryptoDevInfo> iterator = this.getDevInfos().iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"devInfos.iterator()");
        Iterator<CryptoDevInfo> devIter = iterator;
        Log.d((String)"ChipManagerDriver", (String)("ChipManager device type : " + type + " removed"));
        Log.d((String)"ChipManagerDriver", (String)("Chip removed : Device list size " + this.getDevInfos().size()));
        while (devIter.hasNext()) {
            CryptoDevInfo devInfo = devIter.next();
            if (devInfo.getType() != this.typeCovert(type)) continue;
            Log.d((String)"ChipManagerDriver", (String)("Device id " + devInfo.getCardId() + " removed"));
            devIter.remove();
            CryptoDevInfo cryptoDevInfo = devInfo;
            Intrinsics.checkExpressionValueIsNotNull((Object)cryptoDevInfo, (String)"devInfo");
            this.deviceRemoved(cryptoDevInfo);
        }
        if (this.typeCovert(type) == CryptoDevType.DEV_TYPE_Soft) {
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, type, null){
                private CoroutineScope p$;
                Object L$0;
                int label;
                final /* synthetic */ ChipManagerDriver this$0;
                final /* synthetic */ int $type;

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            $this$launch = this.p$;
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = DelayKt.delay((long)1000L, (Continuation)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl16
                        }
                        case 1: {
                            $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl16:
                            // 2 sources

                            pair = ChipManagerDriver.access$getJniApiManager$p(this.this$0).make(ChipManagerDriver.access$getContext$p(this.this$0), this.$type);
                            v1 = (Integer)pair.first;
                            if (v1 == null || v1 != 0) {
                                Log.e((String)"ChipManagerDriver", (String)("Remake vhsm return " + (Integer)pair.first));
                            } else {
                                Log.e((String)"ChipManagerDriver", (String)"Remake vhsm success!");
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.this$0 = chipManagerDriver;
                    this.$type = n;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @Override
    public void serviceDeath() {
        Log.e((String)"ChipManagerDriver", (String)"Service died");
    }

    @Override
    public void serviceStart() {
        Log.e((String)"ChipManagerDriver", (String)"Service start");
    }

    public static final /* synthetic */ JarMultiJniApiManager access$getJniApiManager$p(ChipManagerDriver $this) {
        return $this.jniApiManager;
    }

    public static final /* synthetic */ Context access$getContext$p(ChipManagerDriver $this) {
        return $this.context;
    }

    public static final /* synthetic */ void access$setContext$p(ChipManagerDriver $this, Context context) {
        $this.context = context;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/xdja/cryptodev/driver/chipmanager/ChipManagerDriver$Companion;", "", "()V", "DRIVER_NAME", "", "THIS_FILE", "driverName", "crypto_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

