/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptodev.driver.koal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.xdja.cryptodev.CryptoDevFactory;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.cryptodev.driver.IDevDriver;
import com.xdja.cryptodev.driver.koal.KoalKey;
import com.xdja.cryptodev.util.StringUtil;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import koal.cert.tools.ICertManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016R\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/xdja/cryptodev/driver/koal/KoalDriver;", "Lcom/xdja/cryptodev/driver/IDevDriver;", "()V", "<set-?>", "Lkoal/cert/tools/ICertManager;", "certManager", "getCertManager", "()Lkoal/cert/tools/ICertManager;", "conn", "Landroid/content/ServiceConnection;", "context", "Landroid/content/Context;", "driverName", "", "getDriverName", "()Ljava/lang/String;", "createInstance", "Lcom/xdja/cryptodev/devapi/CryptoInstance;", "devInfo", "Lcom/xdja/cryptodev/CryptoDevInfo;", "destroy", "", "init", "", "refresh", "Companion", "crypto_release"})
public final class KoalDriver
extends IDevDriver {
    private Context context;
    @Nullable
    private ICertManager certManager;
    private final ServiceConnection conn = new ServiceConnection(this){
        final /* synthetic */ KoalDriver this$0;

        public void onServiceConnected(@NotNull ComponentName name, @NotNull IBinder service) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
            Log.d((String)"KoalDriver", (String)"Koal service connected");
            ICertManager iCertManager = ICertManager.Stub.asInterface(service);
            if (iCertManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type koal.cert.tools.ICertManager");
            }
            KoalDriver.access$setCertManager$p(this.this$0, iCertManager);
            List<String> certList = null;
            try {
                ICertManager iCertManager2 = this.this$0.getCertManager();
                if (iCertManager2 == null) {
                    Intrinsics.throwNpe();
                }
                certList = iCertManager2.SOF_GetUserList();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            if (certList == null || certList.isEmpty()) {
                Log.e((String)"KoalDriver", (String)"No koal soft cert in system");
                return;
            }
            for (String certPath : certList) {
                String[] params;
                Iterator<CryptoDevInfo> devIter;
                Intrinsics.checkExpressionValueIsNotNull(this.this$0.getDevInfos().iterator(), (String)"devInfos.iterator()");
                while (devIter.hasNext()) {
                    CryptoDevInfo devInfo = devIter.next();
                    if (!Intrinsics.areEqual((Object)devInfo.getCardId(), (Object)certPath)) continue;
                    Log.d((String)"KoalDriver", (String)("Device id " + certPath + " already in devlist"));
                    return;
                }
                CharSequence charSequence = certPath;
                String string = "/";
                int n = 0;
                string = new Regex(string);
                n = 0;
                boolean bl = false;
                String[] $this$toTypedArray$iv = (String[])string.split(charSequence, n);
                boolean $i$f$toTypedArray2 = false;
                String[] thisCollection$iv = $this$toTypedArray$iv;
                if (thisCollection$iv.toArray(new String[0]) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Log.d((String)"KoalDriver", (String)("Cert path  : " + certPath));
                $this$toTypedArray$iv = params;
                $i$f$toTypedArray2 = false;
                Object object = $this$toTypedArray$iv;
                bl = false;
                if (!(((String[])object).length == 0) && Intrinsics.areEqual((Object)params[0], (Object)"dev1")) {
                    String $i$f$toTypedArray2 = certPath;
                    object = Charsets.UTF_8;
                    bl = false;
                    String string2 = $i$f$toTypedArray2;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray = string2.getBytes((Charset)object);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    String cardId = StringUtil.bytesToHexString(byArray);
                    CryptoDevInfo devInfo = new CryptoDevInfo();
                    devInfo.setType(CryptoDevType.DEV_TYPE_Soft);
                    devInfo.setCardId(cardId);
                    devInfo.setFactory(CryptoDevFactory.FACTORY_KOAL);
                    devInfo.setDriver(this.this$0.getDriverName());
                    this.this$0.getDevInfos().add(devInfo);
                    this.this$0.deviceAdded(devInfo);
                    continue;
                }
                Log.e((String)"KoalDriver", (String)("Do not support " + params[0] + " device from koal. Should call it directly"));
            }
        }

        public void onServiceDisconnected(@NotNull ComponentName name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Log.e((String)"KoalDriver", (String)"Koal service disconnected");
            KoalDriver.access$setCertManager$p(this.this$0, null);
            this.this$0.getDevInfos().clear();
            this.this$0.refresh();
            this.this$0.init();
        }
        {
            this.this$0 = $outer;
        }
    };
    @NotNull
    private static final String DRIVER_NAME = "KoalKey";
    private static final String THIS_FILE = "KoalDriver";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final ICertManager getCertManager() {
        return this.certManager;
    }

    @Override
    @NotNull
    public String getDriverName() {
        return DRIVER_NAME;
    }

    @Override
    public int init() {
        this.context = CryptoDevManager.Companion.getInstance().getContext();
        Intent intent = new Intent();
        intent.setAction("koal.cert.tools.CertManagerService");
        intent.setComponent(new ComponentName("kl.cds", "kl.cds.service.CertManagerService"));
        Log.d((String)THIS_FILE, (String)"start to call bind service");
        Context context = this.context;
        if (context == null) {
            Intrinsics.throwNpe();
        }
        context.bindService(intent, this.conn, 1);
        return 0;
    }

    @Override
    public int refresh() {
        return super.refresh();
    }

    @Override
    @Nullable
    public CryptoInstance createInstance(@NotNull CryptoDevInfo devInfo) {
        Intrinsics.checkParameterIsNotNull((Object)devInfo, (String)"devInfo");
        CryptoInstance instance = new KoalKey(this, devInfo);
        this.getCryptoDevs().add(instance);
        return instance;
    }

    @Override
    public void destroy() {
        Context context = this.context;
        if (context == null) {
            Intrinsics.throwNpe();
        }
        context.unbindService(this.conn);
        super.destroy();
    }

    static {
        DRIVER_NAME = DRIVER_NAME;
    }

    public static final /* synthetic */ ICertManager access$getCertManager$p(KoalDriver $this) {
        return $this.certManager;
    }

    public static final /* synthetic */ void access$setCertManager$p(KoalDriver $this, ICertManager iCertManager) {
        $this.certManager = iCertManager;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/xdja/cryptodev/driver/koal/KoalDriver$Companion;", "", "()V", "DRIVER_NAME", "", "getDRIVER_NAME", "()Ljava/lang/String;", "THIS_FILE", "crypto_release"})
    public static final class Companion {
        @NotNull
        public final String getDRIVER_NAME() {
            return DRIVER_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

