/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptodev.driver.xdja;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.cryptodev.CryptoDevFactory;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.cryptodev.driver.IDevDriver;
import com.xdja.cryptodev.driver.xdja.XdjaKey;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0014H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/xdja/cryptodev/driver/xdja/XdjaDevDriver;", "Lcom/xdja/cryptodev/driver/IDevDriver;", "()V", "context", "Landroid/content/Context;", "driverName", "", "getDriverName", "()Ljava/lang/String;", "jniapi", "Lcom/xdja/SafeKey/JNIAPI;", "sdcardReceiver", "Landroid/content/BroadcastReceiver;", "createInstance", "Lcom/xdja/cryptodev/devapi/CryptoInstance;", "devInfo", "Lcom/xdja/cryptodev/CryptoDevInfo;", "destroy", "", "init", "", "refresh", "typeConvert", "Lcom/xdja/cryptodev/CryptoDevType;", "xdjaType", "Companion", "crypto_release"})
public final class XdjaDevDriver
extends IDevDriver {
    private Context context;
    private final JNIAPI jniapi = new JNIAPI();
    private BroadcastReceiver sdcardReceiver;
    private static final String THIS_FILE = "XdjaDevDriver";
    @NotNull
    private static final byte[] PROJECT_TAG_FID;
    public static final int PROJECT_TAG_LENGTH = 64;
    @NotNull
    public static final String driverName = "XDJADriver";
    @NotNull
    private static byte[][][] xdja_fid_array;
    public static final Companion Companion;

    @Override
    @NotNull
    public String getDriverName() {
        return driverName;
    }

    @Override
    public int init() {
        this.context = CryptoDevManager.Companion.getInstance().getContext();
        this.sdcardReceiver = new BroadcastReceiver(this){
            final /* synthetic */ XdjaDevDriver this$0;

            public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                String action;
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
                String string = action = intent.getAction();
                if (string != null) {
                    switch (string) {
                        case "android.intent.action.MEDIA_EJECT": {
                            Log.d((String)"XdjaDevDriver", (String)"Media disk eject");
                            Iterator<CryptoInstance> iterator = this.this$0.getCryptoDevs().iterator();
                            Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"cryptoDevs.iterator()");
                            Iterator<CryptoInstance> devIterator = iterator;
                            while (devIterator.hasNext()) {
                                CryptoInstance dev = devIterator.next();
                                if (dev.getDevInfo().getType() != CryptoDevType.DEV_TYPE_SdCard) continue;
                                int ret = dev.open();
                                if (ret == 0) {
                                    dev.close();
                                    continue;
                                }
                                dev.close();
                                dev.onError(1005);
                                devIterator.remove();
                            }
                            this.this$0.refresh();
                            break;
                        }
                        case "android.intent.action.MEDIA_MOUNTED": {
                            Log.d((String)"XdjaDevDriver", (String)"Media disk mounted. Need to rescan tf device");
                            this.this$0.refresh();
                            break;
                        }
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        IntentFilter sdcardFilter = new IntentFilter();
        sdcardFilter.addAction("android.intent.action.MEDIA_EJECT");
        sdcardFilter.addAction("android.intent.action.MEDIA_MOUNTED");
        sdcardFilter.addDataScheme("file");
        Context context = this.context;
        if (context == null) {
            Intrinsics.throwNpe();
        }
        context.registerReceiver(this.sdcardReceiver, sdcardFilter);
        this.refresh();
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int refresh() {
        int n;
        int ret = 0;
        int[] devCnt = new int[1];
        Context context = this.context;
        if (context == null) {
            Intrinsics.throwNpe();
        }
        String packageName = context.getPackageName();
        int[] devNum = new int[1];
        long[] handle = new long[1];
        XDJA_DEVINFO xdja_devinfo = new XDJA_DEVINFO();
        this.getDevInfos().clear();
        String string = packageName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"packageName");
        String string2 = string;
        JNIAPI jNIAPI = this.jniapi;
        Object object = Charsets.UTF_8;
        int n2 = 0;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes((Charset)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        ret = jNIAPI.OpenDevByNameEx(byArray2, handle);
        if (ret != 0) {
            Log.d((String)THIS_FILE, (String)("OpenDevByNameEx failed. return " + ret));
        } else {
            ret = this.jniapi.GetDevInfo(handle[0], xdja_devinfo);
            if (ret == 0) {
                Intrinsics.checkExpressionValueIsNotNull((Object)xdja_devinfo.cardid, (String)"xdja_devinfo.cardid");
                object = xdja_devinfo.cardid;
                n2 = 0;
                int n3 = 32;
                n = 0;
                String cardId = new String((byte[])object, n2, n3, Charsets.UTF_8);
                CryptoDevInfo devInfo = new CryptoDevInfo();
                devInfo.setType(this.typeConvert(xdja_devinfo.cardtype));
                devInfo.setDriver(this.getDriverName());
                devInfo.setCardId(cardId);
                devInfo.setFactory(CryptoDevFactory.FACTORY_XDJA);
                this.getDevInfos().add(devInfo);
            }
            this.jniapi.CloseDev(handle[0]);
        }
        ret = this.jniapi.EnumDev(0, devCnt);
        if (ret != 0) {
            Log.d((String)THIS_FILE, (String)("EnumDev faild. return " + ret));
            return 0;
        }
        int cardId = 0;
        int n4 = devCnt[0];
        while (cardId < n4) {
            void i;
            ret = this.jniapi.OpenDev((int)i, handle);
            if (ret != 0) {
                Log.e((String)THIS_FILE, (String)("OpenDev failed. index " + (int)i + " return " + ret));
            } else {
                ret = this.jniapi.GetDevInfo(handle[0], xdja_devinfo);
                if (ret == 0) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)xdja_devinfo.cardid, (String)"xdja_devinfo.cardid");
                    byte[] byArray3 = xdja_devinfo.cardid;
                    n = 0;
                    int n5 = 32;
                    boolean bl = false;
                    String cardId2 = new String(byArray3, n, n5, Charsets.UTF_8);
                    if (CryptoDevManager.Companion.inDevList((List<? extends CryptoDevInfo>)this.getDevInfos(), cardId2)) {
                        Log.d((String)THIS_FILE, (String)"Device already in dev list");
                        this.jniapi.CloseDev(handle[0]);
                    } else {
                        CryptoDevInfo devInfo = new CryptoDevInfo();
                        devInfo.setType(this.typeConvert(xdja_devinfo.cardtype));
                        devInfo.setDriver(this.getDriverName());
                        devInfo.setCardId(cardId2);
                        devInfo.setFactory(CryptoDevFactory.FACTORY_XDJA);
                        this.getDevInfos().add(devInfo);
                        this.jniapi.CloseDev(handle[0]);
                    }
                }
            }
            ++i;
        }
        return super.refresh();
    }

    private final CryptoDevType typeConvert(int xdjaType) {
        CryptoDevType cryptoDevType;
        switch (xdjaType) {
            case 531: 
            case 533: 
            case 535: {
                cryptoDevType = CryptoDevType.DEV_TYPE_Chip;
                break;
            }
            case 512: 
            case 528: {
                cryptoDevType = CryptoDevType.DEV_TYPE_SdCard;
                break;
            }
            case 256: {
                cryptoDevType = CryptoDevType.DEV_TYPE_UsbKey;
                break;
            }
            default: {
                cryptoDevType = CryptoDevType.DEV_TYPE_Chip;
            }
        }
        return cryptoDevType;
    }

    @Override
    @Nullable
    public CryptoInstance createInstance(@NotNull CryptoDevInfo devInfo) {
        Intrinsics.checkParameterIsNotNull((Object)devInfo, (String)"devInfo");
        CryptoInstance dev = new XdjaKey(this, devInfo);
        this.getCryptoDevs().add(dev);
        return dev;
    }

    @Override
    public void destroy() {
        Context context = this.context;
        if (context == null) {
            Intrinsics.throwNpe();
        }
        context.unregisterReceiver(this.sdcardReceiver);
        super.destroy();
    }

    static {
        Companion = new Companion(null);
        PROJECT_TAG_FID = new byte[]{0, (byte)159};
        xdja_fid_array = new byte[][][]{new byte[][]{{41, 42, 43}, {44, 45, 46}}, new byte[][]{{48, 49, 50}, {51, 52, 53}}, new byte[][]{{55, 56, 57}, {58, 59, 60}}, new byte[][]{{62, 63, 64}, {65, 66, 67}}, new byte[][]{{69, 70, 71}, {72, 73, 74}}, new byte[][]{{76, 77, 78}, {79, 80, 81}}, new byte[][]{{83, 84, 85}, {86, 87, 88}}, new byte[][]{{90, 91, 92}, {93, 94, 95}}, new byte[][]{{97, 98, 99}, {100, 101, 102}}, new byte[][]{{104, 105, 106}, {107, 108, 109}}};
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\bJ\u0016\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\bJ\u001e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R(\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\r0\rX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/xdja/cryptodev/driver/xdja/XdjaDevDriver$Companion;", "", "()V", "PROJECT_TAG_FID", "", "getPROJECT_TAG_FID", "()[B", "PROJECT_TAG_LENGTH", "", "THIS_FILE", "", "driverName", "xdja_fid_array", "", "getXdja_fid_array", "()[[[B", "setXdja_fid_array", "([[[B)V", "[[[B", "getExchCertFidOfContainer", "containerId", "getExchPrikeyFidOfContainer", "getExchPubkeyFidOfContainer", "getSignCertFidOfContainer", "certType", "getSignPrikeyFidOfContainer", "getSignPubkeyFidOfContainer", "certtype", "keytype", "crypto_release"})
    public static final class Companion {
        @NotNull
        public final byte[] getPROJECT_TAG_FID() {
            return PROJECT_TAG_FID;
        }

        @NotNull
        public final byte[][][] getXdja_fid_array() {
            return xdja_fid_array;
        }

        public final void setXdja_fid_array(@NotNull byte[][][] byArray) {
            Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"<set-?>");
            xdja_fid_array = byArray;
        }

        @NotNull
        public final byte[] getSignCertFidOfContainer(int containerId) {
            byte[] fid = new byte[]{0, this.getXdja_fid_array()[containerId][1][0]};
            return fid;
        }

        @NotNull
        public final byte[] getSignCertFidOfContainer(int containerId, int certType) {
            byte[] fid = new byte[]{0, this.getXdja_fid_array()[containerId][certType][0]};
            return fid;
        }

        @NotNull
        public final byte[] getExchCertFidOfContainer(int containerId) {
            byte[] fid = new byte[]{0, this.getXdja_fid_array()[containerId][0][0]};
            return fid;
        }

        @NotNull
        public final byte[] getSignPubkeyFidOfContainer(int containerId, int certtype, int keytype) {
            byte[] fid = new byte[]{0, this.getXdja_fid_array()[containerId][certtype][keytype]};
            return fid;
        }

        @NotNull
        public final byte[] getSignPubkeyFidOfContainer(int containerId) {
            byte[] fid = new byte[]{0, this.getXdja_fid_array()[containerId][1][1]};
            return fid;
        }

        @NotNull
        public final byte[] getSignPrikeyFidOfContainer(int containerId) {
            byte[] fid = new byte[]{0, this.getXdja_fid_array()[containerId][1][2]};
            return fid;
        }

        @NotNull
        public final byte[] getExchPubkeyFidOfContainer(int containerId) {
            byte[] fid = new byte[]{0, this.getXdja_fid_array()[containerId][0][1]};
            return fid;
        }

        @NotNull
        public final byte[] getExchPrikeyFidOfContainer(int containerId) {
            byte[] fid = new byte[]{0, this.getXdja_fid_array()[containerId][0][2]};
            return fid;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

