/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptodev.driver.xdja;

import android.content.Context;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevManagerKt;
import com.xdja.cryptodev.error.ErrorCallback;
import com.xdja.cryptodev.error.SysError;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/xdja/cryptodev/driver/xdja/XdjaError;", "Lcom/xdja/cryptodev/error/ErrorCallback;", "()V", "errorBegin", "", "getErrorBegin", "()I", "errorEnd", "getErrorEnd", "getComment", "", "errCode", "getXdjaErrorText", "Companion", "crypto_release"})
public final class XdjaError
extends ErrorCallback {
    public static final int E_ERRNO_BEGIN = 2000;
    public static final int E_ERRNO_END = 3000;
    public static final Companion Companion = new Companion(null);

    @Override
    public int getErrorBegin() {
        return 2000;
    }

    @Override
    public int getErrorEnd() {
        return 3000;
    }

    @Override
    @Nullable
    public String getComment(int errCode) {
        return this.getXdjaErrorText(Companion.errorFromXdja(errCode));
    }

    private final String getXdjaErrorText(int errCode) {
        String string;
        Context context = CryptoDevManager.Companion.getInstance().getContext();
        switch (errCode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = CryptoDevManagerKt.getSTRINGRES().getXDJA_PIN_ERROR_HEAD() + errCode + CryptoDevManagerKt.getSTRINGRES().getXDJA_PIN_ERROR_TAIL();
                break;
            }
            case -1: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_NO_HANDLE();
                break;
            }
            case -2: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_IO_FAILED();
                break;
            }
            case -3: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_BACK_LENGTH();
                break;
            }
            case -4: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_BACK_DATA();
                break;
            }
            case -5: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_RESET_FAILED();
                break;
            }
            case -6: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_NO_ROLE();
                break;
            }
            case -7: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_DATAIN_SIZE();
                break;
            }
            case -8: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_OUTBUF_SIZE();
                break;
            }
            case -9: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_INVALID_PARA();
                break;
            }
            case -10: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_PASSWORD();
                break;
            }
            case -11: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_EEPROM_WRITE();
                break;
            }
            case -12: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_PARAMETER();
                break;
            }
            case -13: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_CMD_NOTMATCH_LINE();
                break;
            }
            case -14: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_CMD_NOTMATCH_FAT();
                break;
            }
            case -15: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_NO_POWER();
                break;
            }
            case -16: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_KEY_LOCKED();
                break;
            }
            case -18: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_DATA_PARAMETER();
                break;
            }
            case -19: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_APP_LOCKED();
                break;
            }
            case -20: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_FILE_NOT_EXIST();
                break;
            }
            case -21: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_NO_FILE_SPACE();
                break;
            }
            case -22: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_NOT_GET_RANDOM();
                break;
            }
            case -23: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_FILE_EXIST();
                break;
            }
            case -24: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_FILE_CONTENT();
                break;
            }
            case -25: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_WRONG_STATE();
                break;
            }
            case -26: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_CARD_LOCKED();
                break;
            }
            case -27: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_WRONG_LE();
                break;
            }
            case -28: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_NO_THIS_CMD();
                break;
            }
            case -29: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_INVALID_DATA();
                break;
            }
            case -30: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_WRONG_MAC();
                break;
            }
            case -31: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_KEYFILE_NOT_EXIST();
                break;
            }
            case -32: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_KEY_NOT_EXIST();
                break;
            }
            case -33: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_WRONG_KEY_TYPE();
                break;
            }
            case -34: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_BAD_PUBKEY();
                break;
            }
            case -35: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_HASH_FAILED();
                break;
            }
            case -36: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_RSAPUBLIC_FAILED();
                break;
            }
            case -37: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_BAD_PRIKEY();
                break;
            }
            case -38: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_SIGN_CONFIRM();
                break;
            }
            case -39: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_SIGN_CANCEL();
                break;
            }
            case -40: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_CONDITION();
                break;
            }
            case -41: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_DECRYPT_FAIL();
                break;
            }
            case -42: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_NOT_FIND_DATA();
                break;
            }
            case -43: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_DGI_NOT_SUPPORT();
                break;
            }
            case -44: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_DATA_NOCORRENT();
                break;
            }
            case -45: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_EXAUTH_FAIL();
                break;
            }
            case -46: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_RSA_NOT_FIND();
                break;
            }
            case -47: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_TLOCK_FAILD();
                break;
            }
            case -48: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_TLOCK_TIMEOUT();
                break;
            }
            case -49: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_BAD_CERT();
                break;
            }
            case -50: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_SIGN_VERIFY();
                break;
            }
            case -51: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_GETMOUNTPATH_FAILD();
                break;
            }
            case -95: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_MALLOC_FALID();
                break;
            }
            case -97: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_NO_KEY();
                break;
            }
            case -98: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_NOT_SUPPORT();
                break;
            }
            case -99: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_NOT_ACTIVATED();
                break;
            }
            default: {
                string = CryptoDevManagerKt.getSTRINGRES().getXKR_UNKNOWN();
            }
        }
        return string;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/xdja/cryptodev/driver/xdja/XdjaError$Companion;", "", "()V", "E_ERRNO_BEGIN", "", "E_ERRNO_END", "errorFromXdja", "xdjaCode", "errorToXdja", "code", "inXdjaErrorRange", "", "errCode", "crypto_release"})
    public static final class Companion {
        public final boolean inXdjaErrorRange(int errCode) {
            return SysError.Companion.inRange(errCode, -200, 10);
        }

        public final int errorFromXdja(int xdjaCode) {
            return xdjaCode == 0 ? 0 : 2010 - xdjaCode;
        }

        public final int errorToXdja(int code) {
            return SysError.Companion.inRange(code, 2000, 3000) ? 2010 - code : 1000;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

