/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptodev.error;

import android.content.Context;
import android.util.Log;
import com.xdja.cryptodev.CryptoDevManagerKt;
import com.xdja.cryptodev.error.ErrorCallback;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0007J\u0010\u0010\u0013\u001a\u00020\t2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/xdja/cryptodev/error/SysError;", "", "()V", "context", "Landroid/content/Context;", "errorCallbacks", "Ljava/util/ArrayList;", "Lcom/xdja/cryptodev/error/ErrorCallback;", "clearErrors", "", "getCommonErrorText", "", "errCode", "", "getErrorText", "isErrorRegistered", "", "registerError", "errorCallback", "setContext", "Companion", "crypto_release"})
public final class SysError {
    private Context context;
    private final ArrayList<ErrorCallback> errorCallbacks = new ArrayList();
    public static final int SUCCESS = 0;
    private static final int E_COMMON_BEGIN = 1000;
    public static final int E_UNKOWN = 1000;
    public static final int E_EXISTS = 1001;
    public static final int E_TOOMANEY = 1002;
    public static final int E_INVALID_ARG = 1003;
    public static final int E_TOOLONG = 1004;
    public static final int E_SDEJECT = 1005;
    public static final int E_NOT_EXISTS = 1006;
    public static final int E_NOT_IMP = 1007;
    public static final int E_EMPTY = 1008;
    private static final int E_COMMON_END = 2000;
    private static final String THIS_FILE = "SysError";
    public static final Companion Companion = new Companion(null);

    public final void setContext(@Nullable Context context) {
        this.context = context;
    }

    public final int registerError(@NotNull ErrorCallback errorCallback) {
        Intrinsics.checkParameterIsNotNull((Object)errorCallback, (String)"errorCallback");
        if (this.errorCallbacks.contains(errorCallback)) {
            Log.d((String)THIS_FILE, (String)"Error callback already registered");
            return 0;
        }
        int begin = errorCallback.getErrorBegin();
        int end = errorCallback.getErrorEnd();
        for (ErrorCallback cb : this.errorCallbacks) {
            if (!Companion.inRange(begin, cb.getErrorBegin(), cb.getErrorEnd()) && !Companion.inRange(end - 1, cb.getErrorBegin(), cb.getErrorEnd())) continue;
            Log.d((String)THIS_FILE, (String)"Error cannot registered, has conclusion");
            return 1001;
        }
        this.errorCallbacks.add(errorCallback);
        return 0;
    }

    @Nullable
    public final String getErrorText(int errCode) {
        if (errCode == 0) {
            return CryptoDevManagerKt.getSTRINGRES().getE_SUCCESS();
        }
        if (Companion.inRange(errCode, 1000, 2000)) {
            return this.getCommonErrorText(errCode);
        }
        for (ErrorCallback cb : this.errorCallbacks) {
            if (!Companion.inRange(errCode, cb.getErrorBegin(), cb.getErrorEnd())) continue;
            return cb.getComment(errCode);
        }
        Log.d((String)THIS_FILE, (String)"Handler not found.");
        return CryptoDevManagerKt.getSTRINGRES().getE_UNKNOWN();
    }

    public final boolean isErrorRegistered(int errCode) {
        if (errCode == 0) {
            return true;
        }
        if (Companion.inRange(errCode, 1000, 2000)) {
            return true;
        }
        for (ErrorCallback cb : this.errorCallbacks) {
            if (!Companion.inRange(errCode, cb.getErrorBegin(), cb.getErrorEnd())) continue;
            return true;
        }
        return false;
    }

    public final void clearErrors() {
        this.errorCallbacks.clear();
    }

    private final String getCommonErrorText(int errCode) {
        String string;
        switch (errCode) {
            case 1001: {
                string = CryptoDevManagerKt.getSTRINGRES().getE_EXISTS();
                break;
            }
            case 1003: {
                string = CryptoDevManagerKt.getSTRINGRES().getE_INVALID_ARG();
                break;
            }
            case 1005: {
                string = CryptoDevManagerKt.getSTRINGRES().getE_SDEJECT();
                break;
            }
            case 1004: {
                string = CryptoDevManagerKt.getSTRINGRES().getE_TOOLONG();
                break;
            }
            case 1002: {
                string = CryptoDevManagerKt.getSTRINGRES().getE_TOOMANY();
                break;
            }
            case 1006: {
                string = CryptoDevManagerKt.getSTRINGRES().getE_NOT_EXISTS();
                break;
            }
            case 1007: {
                string = CryptoDevManagerKt.getSTRINGRES().getE_NOT_IMPL();
                break;
            }
            case 1008: {
                string = CryptoDevManagerKt.getSTRINGRES().getE_EMPTY();
                break;
            }
            case 1000: {
                string = CryptoDevManagerKt.getSTRINGRES().getE_UNKNOWN();
                break;
            }
            default: {
                string = CryptoDevManagerKt.getSTRINGRES().getE_UNKNOWN();
            }
        }
        return string;
    }

    @JvmStatic
    public static final boolean inRange(int code, int begin, int end) {
        return Companion.inRange(code, begin, end);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/xdja/cryptodev/error/SysError$Companion;", "", "()V", "E_COMMON_BEGIN", "", "E_COMMON_END", "E_EMPTY", "E_EXISTS", "E_INVALID_ARG", "E_NOT_EXISTS", "E_NOT_IMP", "E_SDEJECT", "E_TOOLONG", "E_TOOMANEY", "E_UNKOWN", "SUCCESS", "THIS_FILE", "", "inRange", "", "code", "begin", "end", "crypto_release"})
    public static final class Companion {
        @JvmStatic
        public final boolean inRange(int code, int begin, int end) {
            return code >= begin && code < end;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

