/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.initvhsm.net.bean.request;

import com.xdja.initvhsm.utils.RandomUtil;
import okio.Buffer;

public abstract class Request {
    public static final byte[] REQUEST_HEAD_FLAG = "vhsm".getBytes();
    public static final byte[] VERSION = new byte[]{16, 0, 0, 1};
    private byte[] seriesNumber;

    public abstract byte[] getFlag();

    public abstract byte[] getData();

    public abstract int getDataLen();

    public byte[] toBytes() {
        Buffer buffer = new Buffer();
        buffer.write(REQUEST_HEAD_FLAG);
        buffer.write(this.getFlag());
        buffer.write(VERSION);
        buffer.write(this.getSeriesNumber());
        buffer.writeIntLe(this.getDataLen());
        buffer.write(this.getData());
        return buffer.readByteArray();
    }

    public byte[] toBytesUseEncData(byte[] encData) {
        Buffer buffer = new Buffer();
        buffer.write(REQUEST_HEAD_FLAG);
        buffer.write(this.getFlag());
        buffer.write(VERSION);
        buffer.write(this.getSeriesNumber());
        buffer.writeIntLe(encData.length);
        buffer.write(encData);
        return buffer.readByteArray();
    }

    public byte[] getSeriesNumber() {
        if (this.seriesNumber == null) {
            this.seriesNumber = this.genSeriesNumber();
        }
        return this.seriesNumber;
    }

    private byte[] genSeriesNumber() {
        return RandomUtil.getRandomFromDevRandom(4);
    }
}

