/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.initvhsm.net.bean.response;

import com.xdja.initvhsm.net.bean.response.Response;
import java.io.EOFException;
import java.util.Arrays;
import okio.Buffer;

public class InitResponse
extends Response {
    public static final byte[] FLAG = new byte[]{0, 1};
    private int rLen;
    private int wLen;
    private int kLen;
    private int dLen;

    @Override
    protected byte[] reallyFlag() {
        return FLAG;
    }

    @Override
    public boolean parse(byte[] buffer) {
        boolean flag = super.parse(buffer);
        if (!flag) {
            return false;
        }
        Buffer b = new Buffer();
        try {
            b.write(this.data);
            byte[] tmp = b.readByteArray(4L);
            if (!Arrays.equals("rand".getBytes(), tmp)) {
                this.errorCode = -10002;
                return false;
            }
            this.rLen = b.readIntLe();
            b.skip((long)this.rLen);
            tmp = b.readByteArray(4L);
            if (!Arrays.equals("wbox".getBytes(), tmp)) {
                this.errorCode = -10002;
                return false;
            }
            this.wLen = b.readIntLe();
            b.skip((long)this.wLen);
            tmp = b.readByteArray(4L);
            if (!Arrays.equals("kdat".getBytes(), tmp)) {
                this.errorCode = -10002;
                return false;
            }
            this.kLen = b.readIntLe();
            b.skip((long)this.kLen);
            tmp = b.readByteArray(4L);
            if (!Arrays.equals("dona".getBytes(), tmp)) {
                this.errorCode = -10002;
                return false;
            }
            this.dLen = b.readIntLe();
            b.skip((long)this.dLen);
            return true;
        }
        catch (EOFException e) {
            e.printStackTrace();
            this.errorCode = -10002;
            return false;
        }
    }

    public byte[] getRandData() {
        int start = 8;
        int end = start + this.rLen;
        return Arrays.copyOfRange(this.data, start, end);
    }

    public byte[] getWboxData() {
        int start = 8 + this.rLen + 4 + 4;
        int end = start + this.wLen;
        return Arrays.copyOfRange(this.data, start, end);
    }

    public byte[] getKdatData() {
        int start = 8 + this.rLen + 4 + 4 + this.wLen + 4 + 4;
        int end = start + this.kLen;
        return Arrays.copyOfRange(this.data, start, end);
    }

    public byte[] getDonaData() {
        int start = 8 + this.rLen + 4 + 4 + this.wLen + 4 + 4 + this.kLen + 4 + 4;
        int end = start + this.dLen;
        return Arrays.copyOfRange(this.data, start, end);
    }
}

