/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.initvhsm.utils;

public class ConvertUtil {
    public static final int LEN_SHORT = 2;
    public static final int LEN_CHAR = 2;
    public static final int LEN_INT = 4;
    public static final int LEN_LONG = 8;

    public static byte[] shortToBytes(short number) {
        int temp = number;
        byte[] b = new byte[2];
        for (int i = 0; i < b.length; ++i) {
            b[i] = new Integer(temp & 0xFF).byteValue();
            temp >>= 8;
        }
        return b;
    }

    public static short bytesToShort(byte[] b) {
        short s = 0;
        short s0 = (short)(b[0] & 0xFF);
        short s1 = (short)(b[1] & 0xFF);
        s1 = (short)(s1 << 8);
        s = (short)(s0 | s1);
        return s;
    }

    public static byte[] charToBytes(char c) {
        byte[] b = new byte[]{(byte)((c & 0xFF00) >> 8), (byte)(c & 0xFF)};
        return b;
    }

    public static char bytesToChar(byte[] b) {
        char c = (char)((b[0] & 0xFF) << 8 | b[1] & 0xFF);
        return c;
    }

    public static byte[] intToBytes(int i) {
        byte[] bt = new byte[]{(byte)(0xFF & i), (byte)((0xFF00 & i) >> 8), (byte)((0xFF0000 & i) >> 16), (byte)((0xFF000000 & i) >> 24)};
        return bt;
    }

    public static int bytesToInt(byte[] bytes) {
        int num = bytes[0] & 0xFF;
        num |= bytes[1] << 8 & 0xFF00;
        num |= bytes[2] << 16 & 0xFF0000;
        return num |= bytes[3] << 24 & 0xFF000000;
    }

    public static int bytesToIntLe(byte[] bytes) {
        int i = ConvertUtil.bytesToInt(bytes);
        return (i & 0xFF000000) >>> 24 | (i & 0xFF0000) >>> 8 | (i & 0xFF00) << 8 | (i & 0xFF) << 24;
    }

    public static byte[] longToBytes(long number) {
        long temp = number;
        byte[] b = new byte[8];
        for (int i = 0; i < b.length; ++i) {
            b[i] = new Long(temp & 0xFFL).byteValue();
            temp >>= 8;
        }
        return b;
    }

    public static long bytesToLong(byte[] b) {
        long s = 0L;
        long s0 = b[0] & 0xFF;
        long s1 = b[1] & 0xFF;
        long s2 = b[2] & 0xFF;
        long s3 = b[3] & 0xFF;
        long s4 = b[4] & 0xFF;
        long s5 = b[5] & 0xFF;
        long s6 = b[6] & 0xFF;
        long s7 = b[7] & 0xFF;
        s = s0 | (s1 <<= 8) | (s2 <<= 16) | (s3 <<= 24) | (s4 <<= 32) | (s5 <<= 40) | (s6 <<= 48) | (s7 <<= 56);
        return s;
    }

    public static byte[] subBytes(byte[] src, int begin, int len) {
        byte[] bs = new byte[len];
        for (int i = begin; i < begin + len; ++i) {
            bs[i - begin] = src[i];
        }
        return bs;
    }

    public static String bytesToStringHex(byte[] data) {
        if (data == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (byte aData : data) {
            sb.append(String.format("%02X ", aData));
        }
        return sb.toString();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(ConvertUtil.charToByte(hexChars[pos]) << 4 | ConvertUtil.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }
}

