/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.initvhsm.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Process;
import android.provider.Settings;
import android.util.Log;
import android.util.Pair;
import com.xdja.crypto.XDJACrypto;
import com.xdja.initvhsm.utils.FileUtil;
import com.xdja.initvhsm.utils.NetVhsmFileUtil;
import java.io.File;
import java.util.Arrays;

public class NetVhsmDeviceIdUtils {
    public static String getDevId(Context context) {
        String androidId = NetVhsmDeviceIdUtils.getAndroidID(context);
        Pair<Integer, String> pair = NetVhsmDeviceIdUtils.getDecIMEI(context, androidId);
        if (pair.second == null) {
            return androidId;
        }
        return (String)pair.second;
    }

    public static String getAndroidID(Context context) {
        return Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public static Pair<Integer, String> getDecIMEI(Context context, String androidId) {
        File configFile = NetVhsmFileUtil.getIMEICfgFile(context);
        if (configFile == null) {
            Log.e((String)"VhsmInit", (String)"config create fail");
            return Pair.create((Object)-10010, null);
        }
        if (!configFile.exists()) {
            return Pair.create((Object)-10010, null);
        }
        Pair<Integer, byte[]> pair = FileUtil.readFile(configFile);
        if ((Integer)pair.first == 0 && pair.second != null) {
            String imei = NetVhsmDeviceIdUtils.getDecodeIMEI(androidId, (byte[])pair.second);
            return Pair.create((Object)0, (Object)imei);
        }
        return Pair.create((Object)pair.first, null);
    }

    private static String getDecodeIMEI(String androidId, byte[] encData) {
        byte[] tmpKey = new byte[16];
        Arrays.fill(tmpKey, (byte)0);
        if (androidId.length() < 16) {
            System.arraycopy(androidId.getBytes(), 0, tmpKey, 0, androidId.length());
        } else {
            System.arraycopy(androidId.getBytes(), 0, tmpKey, 0, 16);
        }
        byte[] dataAfterDec = new byte[encData.length];
        int ret = XDJACrypto.getInstance().SM4New(tmpKey, 0, encData, encData.length, dataAfterDec, null);
        if (ret == 0) {
            return new String(NetVhsmDeviceIdUtils.dataUnfill(dataAfterDec));
        }
        return null;
    }

    private static byte[] dataUnfill(byte[] data) {
        int index = -1;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != 0) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return data;
        }
        byte[] result = new byte[index];
        System.arraycopy(data, 0, result, 0, result.length);
        return result;
    }

    public static int checkSelfPermission(Context context, String permission2) {
        if (permission2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        return context.checkPermission(permission2, Process.myPid(), Process.myUid());
    }
}

