/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.jniapi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.util.Random;

public class Arithmetic {
    public static final int CONTAINER_NAME = 1;
    public static final int EXC_CERT = 2;
    public static final int EXC_PUBKEY = 3;
    public static final int EXC_PRIKEY = 4;
    public static final int SIGN_CERT = 5;
    public static final int SIGN_PUBKEY = 6;
    public static final int SIGN_PRIKEY = 7;
    public static final int CERT_TYPE_RSA1024 = 0;
    public static final int CERT_TYPE_RSA2048 = 1;
    public static final int CERT_TYPE_SM2 = 2;

    public static byte[] genrateRandomByteArray(int len) {
        byte[] result = new byte[len];
        int i = 0;
        Random r = new Random();
        for (i = 0; i < len; ++i) {
            result[i] = (byte)(r.nextInt(255) - 127);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate getX509Certificate(byte[] certContent, int certLen) {
        ByteArrayInputStream in = new ByteArrayInputStream(certContent, 0, certLen);
        CertificateFactory certFactory = null;
        X509Certificate x509Cert = null;
        try {
            certFactory = CertificateFactory.getInstance("X.509");
            x509Cert = (X509Certificate)certFactory.generateCertificate(in);
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return x509Cert;
    }

    public static byte[] convertToFid(int containNo, int certType) {
        byte[] certId = new byte[]{0, (byte)(39 + certType + containNo * 7)};
        return certId;
    }

    public static int getCertType(X509Certificate x509) {
        String oid = x509.getSigAlgOID();
        if (oid.equals("1.2.156.197.1.501") || oid.equals("1.2.156.10197.1.501")) {
            return 2;
        }
        RSAKey publicKey = (RSAKey)((Object)x509.getPublicKey());
        int bits = publicKey.getModulus().bitLength();
        if (1024 == bits) {
            return 0;
        }
        return 1;
    }

    public static byte[] getExchangeCertFid(int containerNo) {
        byte[] fid = new byte[]{0, (byte)(40 + containerNo * 7 + 1)};
        return fid;
    }

    public static byte[] getExchangePubKeyFid(int containerNo) {
        byte[] fid = new byte[]{0, (byte)(40 + containerNo * 7 + 2)};
        return fid;
    }

    public static byte[] getExchangePriKeyFid(int containerNo) {
        byte[] fid = new byte[]{0, (byte)(40 + containerNo * 7 + 3)};
        return fid;
    }

    public static byte[] getSignCertFid(int containerNo) {
        byte[] fid = new byte[]{0, (byte)(40 + containerNo * 7 + 4)};
        return fid;
    }

    public static byte[] getSignPubKeyFid(int containerNo) {
        byte[] fid = new byte[]{0, (byte)(40 + containerNo * 7 + 5)};
        return fid;
    }

    public static byte[] getSignPriKeyFid(int containerNo) {
        byte[] fid = new byte[]{0, (byte)(40 + containerNo * 7 + 6)};
        return fid;
    }
}

