/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.jniapi;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import com.xdja.jar.forcallprovider.ForCallProvider;
import com.xdja.multichip.ICardStatusBinder;
import com.xdja.multichip.jniapi.JarMultiJniApiManager;
import java.util.ArrayList;

public class JarMultiChipStatusManager {
    public static final String TAG = JarMultiChipStatusManager.class.getSimpleName();
    public static final int CARD_STATUS_EXIST = 1;
    public static final int CARD_STATUS_NOT_EXIST = -1;
    public static final int MULTI_CHIP_STATUS_MSG_WHAT_1 = 1;
    private static JarMultiChipStatusManager instance;
    private ICardStatusBinder cardStatusBinder = null;
    private ArrayList<MultiChipStatusListener> listenerList = new ArrayList();
    private Messenger messenger = null;
    private BroadcastReceiver receiver;

    private JarMultiChipStatusManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JarMultiChipStatusManager getInstance() {
        if (instance != null) return instance;
        Class<JarMultiChipStatusManager> clazz = JarMultiChipStatusManager.class;
        synchronized (JarMultiChipStatusManager.class) {
            if (instance != null) return instance;
            instance = new JarMultiChipStatusManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public int sendCardStatus(Context context, String cardId, int cardType, int status) {
        if (context == null) {
            return -10000;
        }
        if (!context.getPackageName().equals(ForCallProvider.getCallPkg((Context)context))) {
            return -10028;
        }
        ICardStatusBinder binder = this.getCardStatusBinder(context);
        if (binder == null) {
            return -10002;
        }
        Bundle bundle = new Bundle();
        bundle.putString("method", "sendCardStatus");
        bundle.putString("cardId", cardId);
        bundle.putInt("cardType", cardType);
        bundle.putInt("status", status);
        try {
            Bundle result = binder.callMethod(bundle);
            if (result != null) {
                int ret = result.getInt("ret");
                return ret;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -10001;
    }

    private void initMessenger(Context context) {
        this.messenger = new Messenger(new Handler(context.getMainLooper()){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                if (msg.what == 1) {
                    Bundle bundle = (Bundle)msg.obj;
                    String cardId = bundle.getString("cardId");
                    int cardType = bundle.getInt("cardType");
                    int status = bundle.getInt("status");
                    if (status == 1) {
                        JarMultiChipStatusManager.this.notifyListenerChipAdd(cardId, cardType);
                    } else if (status == -1) {
                        JarMultiChipStatusManager.this.notifyListenerChipRemove(cardType);
                    }
                }
            }
        });
    }

    public synchronized int registerListener(Context context, MultiChipStatusListener listener) {
        if (listener == null || context == null) {
            return -10000;
        }
        if (this.listenerList.contains(listener)) {
            return 0;
        }
        this.listenerList.add(listener);
        this.registerReceiveServiceStart(context);
        return this.registerToService(context);
    }

    private int registerToService(Context context) {
        ICardStatusBinder binder;
        if (this.messenger == null) {
            this.initMessenger(context);
        }
        if ((binder = this.getCardStatusBinder(context)) == null) {
            return -10002;
        }
        Bundle bundle = new Bundle();
        bundle.putString("method", "registerListener");
        bundle.putBinder("messenger", this.messenger.getBinder());
        try {
            Bundle result = binder.callMethod(bundle);
            if (result != null) {
                int ret = result.getInt("ret");
                return ret;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -10001;
    }

    public int unregisterListener(MultiChipStatusListener listener) {
        if (this.listenerList.contains(listener)) {
            this.listenerList.remove(listener);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ICardStatusBinder getCardStatusBinder(Context context) {
        if (this.cardStatusBinder != null) return this.cardStatusBinder;
        Class<JarMultiJniApiManager> clazz = JarMultiJniApiManager.class;
        synchronized (JarMultiJniApiManager.class) {
            IBinder binder;
            int ret;
            if (this.cardStatusBinder != null) return this.cardStatusBinder;
            ContentResolver resolver = context.getContentResolver();
            Uri uri = this.getUri(context);
            if (uri == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            String method = "GetBinder";
            String arg = "CardStatusBinder";
            Bundle bundle = resolver.call(uri, method, arg, null);
            if (bundle == null || (ret = bundle.getInt("ret")) != 0 || (binder = bundle.getBinder("Binder")) == null) return this.cardStatusBinder;
            this.cardStatusBinder = ICardStatusBinder.Stub.asInterface(binder);
            try {
                binder.linkToDeath(new IBinder.DeathRecipient(){

                    public void binderDied() {
                        JarMultiChipStatusManager.this.cardStatusBinder = null;
                        JarMultiChipStatusManager.this.notifyServiceDeath();
                    }
                }, 0);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            return this.cardStatusBinder;
        }
    }

    private Uri getUri(Context context) {
        return ForCallProvider.getGetProxyProviderUri((Context)context);
    }

    private void registerReceiveServiceStart(Context context) {
        try {
            IntentFilter filter = new IntentFilter();
            filter.addAction("com_xdja_multichip_CardStatusServiceStart");
            context.registerReceiver(this.getReceiver(), filter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private synchronized BroadcastReceiver getReceiver() {
        if (this.receiver == null) {
            this.receiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    Log.e((String)TAG, (String)("receiver: " + intent));
                    if (JarMultiChipStatusManager.this.listenerList != null && JarMultiChipStatusManager.this.listenerList.size() > 0) {
                        JarMultiChipStatusManager.this.registerToService(context);
                    }
                    JarMultiChipStatusManager.this.notifyServiceStart();
                }
            };
        }
        return this.receiver;
    }

    private void notifyListenerChipAdd(String cardId, int cardType) {
        for (MultiChipStatusListener listener : this.listenerList) {
            listener.chipAdd(cardId, cardType);
        }
    }

    private void notifyListenerChipRemove(int cardType) {
        for (MultiChipStatusListener listener : this.listenerList) {
            listener.chipRemove(cardType);
        }
    }

    private void notifyServiceDeath() {
        for (MultiChipStatusListener listener : this.listenerList) {
            listener.serviceDeath();
        }
    }

    private void notifyServiceStart() {
        for (MultiChipStatusListener listener : this.listenerList) {
            listener.serviceStart();
        }
    }

    public static interface MultiChipStatusListener {
        public void chipAdd(String var1, int var2);

        public void chipRemove(int var1);

        public void serviceDeath();

        public void serviceStart();
    }
}

