/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.jniapi;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Pair;
import com.xdja.multichip.IGetMultiJniApi;
import com.xdja.multichip.IMultiJniApi;
import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.multichip.jniapi.JarJniApiTypeProxy;
import com.xdja.multichip.jniapi.JarMultiJniApiManager;
import com.xdja.multichip.param.JniApiParam;

public class JarMultiJniApiVhsmManager {
    private static JarMultiJniApiVhsmManager instance;
    private static final String KEY_RET = "ret";
    private static final String KEY_METHOD = "method";

    private JarMultiJniApiVhsmManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JarMultiJniApiVhsmManager getInstance() {
        if (instance != null) return instance;
        Class<JarMultiJniApiVhsmManager> clazz = JarMultiJniApiVhsmManager.class;
        synchronized (JarMultiJniApiVhsmManager.class) {
            if (instance != null) return instance;
            instance = new JarMultiJniApiVhsmManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Pair<Integer, Pair<JniApiParam, JarJniApiProxy>> createDefaultVhsm(Context context) {
        IGetMultiJniApi multiBinder = JarMultiJniApiManager.getInstance().getGetMultiJniApiBinder(context);
        if (multiBinder == null) {
            return Pair.create((Object)-10002, null);
        }
        Bundle bundle = new Bundle();
        bundle.putString(KEY_METHOD, "CreateDefaultVhsm");
        try {
            Bundle result = multiBinder.callMethod(bundle);
            if (result == null) {
                return Pair.create((Object)-10001, null);
            }
            result.setClassLoader(JniApiParam.class.getClassLoader());
            int ret = result.getInt(KEY_RET);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            JniApiParam jniApiParam = (JniApiParam)result.getParcelable("JniApiParam");
            IBinder binder = result.getBinder("Binder");
            JarJniApiTypeProxy proxy = new JarJniApiTypeProxy(context, IMultiJniApi.Stub.asInterface(binder), jniApiParam.chipType);
            return Pair.create((Object)ret, (Object)Pair.create((Object)jniApiParam, (Object)proxy));
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return Pair.create((Object)-10001, null);
        }
    }

    public int SM4(JarJniApiProxy proxy, byte[] dataIn, int dataLen, int flag, byte[] dataOut, byte kID, byte[] IV) {
        if (proxy == null || dataIn == null || dataIn.length < dataLen || dataOut == null || dataOut.length < dataLen) {
            return -10000;
        }
        if (IV != null && IV.length != 16) {
            return -10000;
        }
        Bundle extras = new Bundle();
        extras.putString(KEY_METHOD, "SM4");
        extras.putByteArray("dataIn", dataIn);
        extras.putInt("dataLen", dataLen);
        extras.putInt("flag", flag);
        extras.putByte("kID", kID);
        extras.putByteArray("IV", IV);
        Bundle bundle = proxy.callMethod(extras);
        if (bundle == null) {
            return -10000;
        }
        int ret = bundle.getInt(KEY_RET);
        byte[] dataOutTmp = null;
        if (ret == 0) {
            dataOutTmp = bundle.getByteArray("dataOut");
            System.arraycopy(dataOutTmp, 0, dataOut, 0, dataOutTmp.length);
            byte[] IVTmp = bundle.getByteArray("IV");
            if (IVTmp != null && IV != null) {
                System.arraycopy(IVTmp, 0, IV, 0, IVTmp.length);
            }
        }
        return ret;
    }
}

