/*
 * Decompiled with CFR 0.152.
 */
package kl.cds.utils;

import android.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;

public class SvsHelper {
    private String SERVER;
    public static final String plainData = "just a test";
    private String SVS_SIGN_DATA;
    private String SVS_VERIFY_DATA;
    private String SVS_SIGN_MESSAGE;
    private String SVS_VERIFY_SIGN_MESSAGE;
    private String SVS_ENCRYPT_MESSAGE;
    private String SVS_DECRYPT_MESSAGE;
    private String SVS_EXPORT_SERVER_CERT;

    public SvsHelper(String Server) {
        this.SERVER = Server;
        this.SVS_SIGN_DATA = this.SERVER + "SignData";
        this.SVS_VERIFY_DATA = this.SERVER + "VerifySignedData";
        this.SVS_SIGN_MESSAGE = this.SERVER + "SignMessage";
        this.SVS_VERIFY_SIGN_MESSAGE = this.SERVER + "VerifySignedMessage";
        this.SVS_ENCRYPT_MESSAGE = this.SERVER + "EncryptMessage";
        this.SVS_DECRYPT_MESSAGE = this.SERVER + "DecryptMessage";
        this.SVS_EXPORT_SERVER_CERT = this.SERVER + "ExportServerCert";
    }

    public String getSigndata() throws Exception {
        URL url = new URL(this.SVS_SIGN_DATA);
        HttpURLConnection conn2 = (HttpURLConnection)url.openConnection();
        conn2.setRequestMethod("POST");
        conn2.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn2.setRequestProperty("HashType", "Sha256");
        PrintWriter out = new PrintWriter(conn2.getOutputStream());
        out.print("Data=" + new String(Base64.encode((byte[])plainData.getBytes(), (int)0)));
        out.flush();
        out.close();
        return SvsHelper.GetHttpRequest(conn2);
    }

    public String verifySigndata(String localCert, byte[] localSignDataByte) throws Exception {
        URL url = new URL(this.SVS_VERIFY_DATA + "?Data=" + new String(Base64.encode((byte[])plainData.getBytes(), (int)0)) + "&SignedData=" + new String(localSignDataByte) + "&Cert=" + localCert);
        HttpURLConnection conn2 = (HttpURLConnection)url.openConnection();
        conn2.setRequestMethod("GET");
        conn2.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn2.setRequestProperty("HashType", "SHA256");
        conn2.setRequestProperty("CertVerifyOption", "None");
        return SvsHelper.GetHttpRequest(conn2);
    }

    public String getSignMessage() throws Exception {
        URL url = new URL(this.SVS_SIGN_MESSAGE);
        HttpURLConnection conn2 = (HttpURLConnection)url.openConnection();
        conn2.setRequestMethod("POST");
        conn2.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn2.setRequestProperty("AttachOrigin", "Yes");
        conn2.setRequestProperty("AttachCert", "Cert");
        PrintWriter out = new PrintWriter(conn2.getOutputStream());
        out.print("Data=" + new String(Base64.encode((byte[])plainData.getBytes(), (int)0)));
        out.flush();
        out.close();
        return SvsHelper.GetHttpRequest(conn2);
    }

    public String verifySignMessage(byte[] localSignMessage) throws Exception {
        URL url = new URL(this.SVS_VERIFY_SIGN_MESSAGE);
        HttpURLConnection conn2 = (HttpURLConnection)url.openConnection();
        conn2.setRequestMethod("POST");
        conn2.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn2.setRequestProperty("CertVerifyOption", "None");
        PrintWriter out = new PrintWriter(conn2.getOutputStream());
        String localSigned = new String(localSignMessage);
        out.print("SignedMessage=" + localSigned);
        out.flush();
        out.close();
        return SvsHelper.GetHttpRequest(conn2);
    }

    public String getEncryptedData(String localCert) throws Exception {
        URL url = new URL(this.SVS_ENCRYPT_MESSAGE);
        HttpURLConnection conn2 = (HttpURLConnection)url.openConnection();
        conn2.setRequestMethod("POST");
        conn2.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn2.setRequestProperty("EncryptAlg", "SM4");
        PrintWriter out = new PrintWriter(conn2.getOutputStream());
        out.print("Data=" + new String(Base64.encode((byte[])plainData.getBytes(), (int)0)) + "&Cert=" + localCert);
        out.flush();
        out.close();
        return SvsHelper.GetHttpRequest(conn2);
    }

    public String DecryptData(String localEncryptData) throws Exception {
        URL url = new URL(this.SVS_DECRYPT_MESSAGE);
        HttpURLConnection conn2 = (HttpURLConnection)url.openConnection();
        conn2.setRequestMethod("POST");
        conn2.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        PrintWriter out = new PrintWriter(conn2.getOutputStream());
        out.print("EncryptedMessage=" + localEncryptData);
        out.flush();
        out.close();
        return SvsHelper.GetHttpRequest(conn2);
    }

    private static String GetHttpRequest(HttpURLConnection conn2) throws Exception {
        StringBuilder resultInfo = new StringBuilder();
        int code = conn2.getResponseCode();
        if (code == 200) {
            String result = new String(SvsHelper.readStream(conn2.getInputStream()));
            resultInfo.append(result + "\n");
        } else if (code == 404) {
            resultInfo.append("\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u7801404 Fail not Find \n");
        } else if (code == 500) {
            resultInfo.append("\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u7801500 Server Internal Error \n");
        } else {
            resultInfo.append("\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u7801" + code + "\n");
        }
        return resultInfo.toString();
    }

    public String getSvsCert() {
        try {
            URL url = new URL(this.SVS_EXPORT_SERVER_CERT);
            HttpURLConnection conn2 = (HttpURLConnection)url.openConnection();
            conn2.setRequestMethod("GET");
            int code = conn2.getResponseCode();
            if (code == 200) {
                String result = new String(SvsHelper.readStream(conn2.getInputStream()));
                return SvsHelper.getReturnData(result);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] readStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outSteam = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = -1;
        while ((len = inStream.read(buffer)) != -1) {
            outSteam.write(buffer, 0, len);
        }
        outSteam.close();
        inStream.close();
        return outSteam.toByteArray();
    }

    public static String getErrorCode(String result) {
        int index = result.indexOf("=");
        return result.substring(index + 1, index + 2);
    }

    public static String getReturnData(String result) {
        int index = result.indexOf("=", 10);
        return result.substring(index + 1);
    }
}

