package com.xdja.aircert.sdk.config;

import android.text.TextUtils;

/**
 * @author: lyl
 * desc:  sdk 配置类
 * 2020/11/2
 */
public final class AirCertConfig {
    /**
     * 服务地址
     */
    private String serverAddress;
    /**
     * vhsm地址
     */
    private String vhsmIpPort;
    /**
     * 容器号
     */
    private int containerNum;
    /**
     * 卡类型
     */
    @AirCertConstant.DEV_TYPE
    private int cardType;
    /**
     * 加密类型
     */
    @AirCertConstant.ALG_TYPE
    private int algType;
    /**
     * 证书类型
     */
    @AirCertConstant.CERT_TYPE
    private String certType;
    /**
     * 根证书名字
     */
    private String rootCertName;

    private AirCertConfig(Builder builder) {
        this.serverAddress = builder.serverAddress;
        this.vhsmIpPort = builder.vhsmIpPort;
        this.containerNum = builder.containerNum;
        this.cardType = builder.cardType == 0 ? AirCertConstant.DEV_TYPE_VHSM : builder.cardType;
        this.algType = builder.algType == 0 ? AirCertConstant.ALG_TYPE_SM2 : builder.algType;
        this.certType = TextUtils.isEmpty(builder.certType) ? AirCertConstant.CERT_TYPE_SIGNATURE : builder.certType;
        this.rootCertName = TextUtils.isEmpty(builder.rootCertName) ? AirCertConstant.ROOT_CERT_NAME : builder.rootCertName;
    }

    public String getServerAddress() {
        return serverAddress;
    }

    public String getVhsmIpPort() {
        return vhsmIpPort;
    }

    public int getContainerNum() {
        return containerNum;
    }

    public int getCardType() {
        return cardType;
    }

    public int getAlgType() {
        return algType;
    }

    public String getCertType() {
        return certType;
    }

    public String getRootCertName() {
        return rootCertName;
    }

    public static class Builder {
        private String serverAddress;
        private String vhsmIpPort;
        private int containerNum;
        @AirCertConstant.DEV_TYPE
        private int cardType;
        @AirCertConstant.ALG_TYPE
        private int algType;
        @AirCertConstant.CERT_TYPE
        private String certType;
        private String rootCertName;

        public void setRootCertName(String rootCertName) {
            this.rootCertName = rootCertName;
        }

        public Builder setServerAddress(String serverAddress) {
            if (TextUtils.isEmpty(serverAddress)) {
                throw new IllegalArgumentException("serverAddress == null");
            }
            this.serverAddress = serverAddress;
            return this;
        }

        public Builder setVhsmIpPort(String vhsmIpPort) {
            if (TextUtils.isEmpty(vhsmIpPort)) {
                throw new IllegalArgumentException("vhsmAddress == null");
            }
            this.vhsmIpPort = vhsmIpPort;
            return this;
        }

        public Builder setContainerNum(int containerNum) {
            this.containerNum = containerNum;
            return this;
        }

        public Builder setCardType(@AirCertConstant.DEV_TYPE int cardType) {
            this.cardType = cardType;
            return this;
        }

        public Builder setAlgType(@AirCertConstant.ALG_TYPE int algType) {
            this.algType = algType;
            return this;
        }

        public Builder setCertType(@AirCertConstant.CERT_TYPE String certType) {
            this.certType = certType;
            return this;
        }

        public AirCertConfig build() {
            if (TextUtils.isEmpty(serverAddress)) {
                throw new IllegalArgumentException("serverAddress == null");
            }
            if (TextUtils.isEmpty(vhsmIpPort)) {
                throw new IllegalArgumentException("vhsmAddress == null");
            }
            return new AirCertConfig(this);
        }
    }
}
