package com.xdja.aircert.sdk.device;

import android.text.TextUtils;

import com.xdja.aircert.sdk.AirCertSdk;
import com.xdja.aircert.sdk.bean.CertDetailInfoBean;
import com.xdja.aircert.sdk.config.AirCertConfig;
import com.xdja.aircert.sdk.config.AirCertConstant;
import com.xdja.aircert.sdk.config.AlgType;
import com.xdja.aircert.sdk.config.CertRule;
import com.xdja.aircert.sdk.config.CertType;
import com.xdja.aircert.sdk.config.ContainerNum;
import com.xdja.aircert.sdk.config.XDJAAlgParams;
import com.xdja.aircert.sdk.util.FidUtil;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;

import org.bouncycastle.jce.provider.BouncyCastleProvider;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Principal;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

/**
 * @author: lyl
 * desc:
 * 2020/11/6
 */
public class CertHelper {
    /**
     * 获取算法类型
     *
     * @return
     */
    public static String getAlgType() {
        String defaultAlgType = AlgType.getDefault();
        AirCertConfig certConfig = AirCertSdk.getsInstance().getAirCertConfig();
        if (certConfig.getAlgType() == AirCertConstant.ALG_TYPE_RSA) {
            return transAlgType(AlgType.RSA);
        }
        return transAlgType(defaultAlgType);
    }

    private static String transAlgType(String algType) {
        return algType.equals(AlgType.RSA) ? XDJAAlgParams.CA_ALG_RSA : XDJAAlgParams.CA_ALG_SM2;
    }

    /**
     * 单证书还是双证书
     *
     * @return
     */
    public static String getCertRule(@AirCertConstant.ALG_TYPE int algType) {
        return algType == AirCertConstant.ALG_TYPE_SM2_DOUBLE ? CertRule.DOUBLE_CERT : CertRule.SINGLE;
    }

    /*  *//**
     * 获取证书类型  签名证书/加密证书
     * @param certType
     * @return
     *//*
    public static String getCertType(@AirCertConstant.CERT_TYPE int certType) {

    }*/

    /**
     * 获取容器角色
     *
     * @param containerNum
     * @return
     */
    public static int getRole(int containerNum) {
//        4、6号容器是0x11，其余是0x01
        if (String.valueOf(containerNum).equals(ContainerNum.FOUR) || String.valueOf(containerNum).equals(ContainerNum.SIX)) {
            return 0x11;
        } else {
            return 0x01;
        }
    }

    /**
     * 获取pin码
     *
     * @return
     */
    public static String getPin() {
        return AirCertConstant.PIN;
    }

    /**
     * 读取卡信息
     *
     * @return
     */
    public static CertDetailInfoBean readCertInfo() {
        return OperateCertHelper.readCertFromContainer(DeviceCache.getsInstance().getCacheCryptoDevInfo().getType(),
                AirCertSdk.getsInstance().getAirCertConfig().getContainerNum(), AirCertSdk.getsInstance().getAirCertConfig().getCertType());
    }

    /**
     * 删除证书
     */
    public static void deleteCert() {
        OperateCertHelper.clearContainer(DeviceWrapper.getCurrentDevInfo().getType(), AirCertSdk.getsInstance().getAirCertConfig().getContainerNum());
    }


    public static boolean verifyCertByRoot(CryptoDevType type, int containerNo) {
        try {
            BouncyCastleProvider provider = new BouncyCastleProvider();

            //Android中自带的 BouncyCastleProvider 不包含 SM3WITHSM2签名算法，所以此处删除该Provider，然后添加引用jar里的 BouncyCastleProvider
            Security.removeProvider("BC");
            Security.addProvider(provider);

            //读取申请的证书
            X509Certificate cert = getX509Certificate(readCertFromType(type, containerNo), provider);

            InputStream is = AirCertSdk.getsInstance().getContext().getAssets().open(AirCertSdk.getsInstance().getAirCertConfig().getRootCertName());

            //读取根证书
            X509Certificate root = getX509Certificate(is, provider);

            if (cert == null || root == null) {
                return false;
            }
            //待验证证书的发布者是否是根证的所有者
            Principal principalIssuer = cert.getIssuerDN();   //获取待验证证书的发布者
            Principal principalSubject = root.getSubjectDN(); //根证书的所有者

            if (!principalIssuer.equals(principalSubject)) {
                return false;
            }
            cert.verify(root.getPublicKey());
            return true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /**
     * 将流转化为 X509Certificate 对象
     *
     * @param is
     * @param provider
     * @return
     */
    public static X509Certificate getX509Certificate(InputStream is, BouncyCastleProvider provider) {
        if (is == null) {
            return null;
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", provider);
            X509Certificate certificate = (X509Certificate) cf.generateCertificate(is);
            is.close();
            return certificate;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 根据芯片类型读取证书
     * 只验证根证书使用
     *
     * @param type
     * @param containerNum
     * @return
     */
    public static InputStream readCertFromType(CryptoDevType type, int containerNum) {

        byte[][] fid = FidUtil.getCertFid(containerNum);


        byte[] certBuf = new byte[2048];
        int[] certLen = new int[1];
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return null;
        }
        int result = -1;

        //因为该方法目前只在验证根证书时使用，并且在现场即存在交换证书也存在签名证书的时候需要必须读出来证书
        if (AirCertSdk.getsInstance().getAirCertConfig().getCertType().equals(CertType.SIGNING)
                || TextUtils.isEmpty(AirCertSdk.getsInstance().getAirCertConfig().getCertType())) {

            result = cryptoInstance.readCert(fid[0], certBuf, certLen);
        } else if (AirCertSdk.getsInstance().getAirCertConfig().getCertType().equals(CertType.ENCRYPT)) {
            result = cryptoInstance.readCert(fid[1], certBuf, certLen);
        }

        cryptoInstance.close();
        if (result == 0) {
            return new ByteArrayInputStream(certBuf);
        } else {
            return null;
        }
    }


}
