package com.xdja.aircert.sdk.net;

import android.util.Log;

import com.xdja.aircert.sdk.AirCertSdk;
import com.xdja.aircert.sdk.R;
import com.xdja.aircert.sdk.device.DeviceCache;
import com.xdja.aircert.sdk.util.SdkLog;
import com.xdja.cryptodev.CryptoDevInfo;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

/**
 * @author: lyl
 * desc:
 * 2020/11/2
 */
public class HttpManager {
    private static final int READ_TIMEOUT = 20;
    private static final int WRITE_TIMEOUT = 20;
    private static final int CONNECTION_TIMEOUT = 20;
    private static HttpManager sInstance;
    private OkHttpClient httpClient;
    private ThreadHelper threadHelper;

    public OkHttpClient getHttpClient() {
        if (null == httpClient) {
            initHttp();
        }
        return httpClient;
    }

    private HttpManager() {
        threadHelper = new ThreadHelper();
        initHttp();
    }

    public static HttpManager getInstance() {
        if (null == sInstance) {
            synchronized (HttpManager.class) {
                if (null == sInstance) {
                    sInstance = new HttpManager();
                }
            }
        }
        return sInstance;
    }

    private void initHttp() {
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder();
        builder.connectTimeout(CONNECTION_TIMEOUT, TimeUnit.SECONDS);
        builder.readTimeout(READ_TIMEOUT, TimeUnit.SECONDS);
        builder.writeTimeout(WRITE_TIMEOUT, TimeUnit.SECONDS);
        builder.addInterceptor(new NetTimeOutInterceptor());
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, configHttpsAttribute(), null);
            builder.sslSocketFactory(sslContext.getSocketFactory(), new X509TrustManager() {
                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            });
            builder.hostnameVerifier(new HostnameVerifier() {
                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            httpClient = builder.build();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private TrustManager[] configHttpsAttribute() {
        try {
//            KeyStore serverKeyStore = KeyStore.getInstance("bks");
//            InputStream inputStream = AirCertSdk.getsInstance().getContext().getResources().openRawResource(R.raw.truststore);
//            serverKeyStore.load(inputStream, "xdja1234".toCharArray());
//            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
//            trustManagerFactory.init(trustAllCerts);
//            return trustManagerFactory.getTrustManagers();



            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager() {
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};

            return trustAllCerts;

        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Request initRequest(String url, String jsonStr) {
        Request.Builder builder = new Request.Builder();
        CryptoDevInfo info = DeviceCache.getsInstance().getCacheCryptoDevInfo();
        builder.addHeader("Content-Type", "application/json")
                .addHeader("cardNo", info.cardId)
                .addHeader("clientTime", String.valueOf(System.currentTimeMillis()))
                .url(HttpUrl.getUrl(url));
        if (jsonStr != null) {
            MediaType mediaType = MediaType.parse("application/json; charset=UTF-8");
            RequestBody body = RequestBody.create(mediaType, jsonStr);
            builder.post(body);
        }
        SdkLog.loge(url+"-------"+jsonStr);
        return builder.build();
    }

    public void executor(Runnable runnable) {
        getInstance().threadHelper.getExecutorService().execute(runnable);
    }

    public void executorUi(Runnable runnable) {
        getInstance().threadHelper.getUiThread().post(runnable);
    }
}
