package com.xdja.aircert.sdk.net;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

/**
 * @author: lyl
 * desc:网络超时监听
 * 2020/11/24
 */
public class NetTimeOutInterceptor implements Interceptor {
    @Override
    public Response intercept(Chain chain) throws IOException {
        Request request = chain.request();
        Response response = null;
        try {
            response = chain.proceed(request);
        } catch (IOException e) {
            HttpUrl.useTelnet();
            throw e;
        }
        return response;
    }
}
