package com.xdja.aircert.sdk.util;

import android.util.Log;

import com.xdja.aircert.sdk.AirCertSdk;

/**
 * @author admin
 */
public class SdkLog {
    /**
     * this must be set false before release
     */
    private static String TAG = "cert_log";

    public static void logi(String msg) {
        if (!AirCertSdk.getsInstance().isPrintLog()) {
            return;
        }
        String funcName = Thread.currentThread().getStackTrace()[3].getMethodName();
        String lineNum = "" + Thread.currentThread().getStackTrace()[3].getLineNumber();
        Log.i(TAG, "[" + funcName + "," + lineNum + "]" + msg);
    }

    public static void logd(String msg) {
        if (!AirCertSdk.getsInstance().isPrintLog()) {
            return;
        }
        String funcName = Thread.currentThread().getStackTrace()[3].getMethodName();
        String lineNum = "" + Thread.currentThread().getStackTrace()[3].getLineNumber();
        Log.d(TAG, "[" + funcName + "," + lineNum + "]" + msg);
    }

    public static void logw(String msg) {
        if (!AirCertSdk.getsInstance().isPrintLog()) {
            return;
        }
        String funcName = Thread.currentThread().getStackTrace()[3].getMethodName();
        String lineNum = "" + Thread.currentThread().getStackTrace()[3].getLineNumber();
        Log.w(TAG, "[" + funcName + "," + lineNum + "]" + msg);
    }

    public static void loge(String msg) {
        if (!AirCertSdk.getsInstance().isPrintLog()) {
            return;
        }
        String funcName = Thread.currentThread().getStackTrace()[3].getMethodName();
        String lineNum = "" + Thread.currentThread().getStackTrace()[3].getLineNumber();
        Log.e(TAG, "[" + funcName + "," + lineNum + "]" + msg);
    }
}
