/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.sdk.device;

import android.content.Context;
import android.os.Environment;
import com.xdja.aircert.sdk.util.SdkLog;
import com.xdja.initvhsm.net.NetRespository;
import com.xdja.initvhsm.utils.NetVhsmCardIdUtil;
import com.xdja.initvhsm.utils.NetVhsmDeviceIdUtils;
import java.io.File;

public class NetVHSMHandle {
    private static final String FILE_DIR = "xdja/vhsm/net/";
    private static final String RAND_FILE_PATH = "xdja/vhsm/net/rand.bin";
    private static final String KDAT_FILE_PATH = "xdja/vhsm/net/vhsm.dat";
    private static final String WBOX_FILE_PATH = "xdja/vhsm/net/wbox.lib";
    private static final String VHSM_LIB_FILE_PATH = "xdja/vhsm/net/vhsm.lib";

    public static String getNetVhsmCardId(Context context) {
        String netVhsmCardId = NetVhsmCardIdUtil.getCardId(NetVhsmDeviceIdUtils.getDevId(context));
        return netVhsmCardId;
    }

    public static boolean initVHSM(Context context, String ipPort) {
        String[] address = ipPort.split(":");
        if (address.length != 2) {
            throw new IllegalArgumentException("vhsmipport error");
        }
        NetRespository netRespository = NetRespository.create(context, address[0], Integer.parseInt(address[1]));
        int initResult = netRespository.init(NetVhsmDeviceIdUtils.getDevId(context));
        SdkLog.loge("37 NetVHSMHandle run :initResult =  " + initResult);
        if (initResult == 0) {
            SdkLog.logi("VHSM\u521d\u59cb\u5316\u6210\u529f");
            int initFile = NetRespository.initVhsmlibFile(context, address[0], Integer.parseInt(address[1]));
            return initFile == 0;
        }
        SdkLog.loge("VHSM\u521d\u59cb\u5316\u5931\u8d25");
        return false;
    }

    public static boolean isNetVHSMCanUse() {
        File storageDir = Environment.getExternalStorageDirectory();
        File randFile = new File(storageDir, RAND_FILE_PATH);
        if (!randFile.exists()) {
            return false;
        }
        File wboxFile = new File(storageDir, WBOX_FILE_PATH);
        if (!wboxFile.exists()) {
            return false;
        }
        File kdatFile = new File(storageDir, KDAT_FILE_PATH);
        if (!kdatFile.exists()) {
            return false;
        }
        File vhsmLibFile = new File(storageDir, VHSM_LIB_FILE_PATH);
        return vhsmLibFile.exists();
    }
}

