/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.sdk.net;

import com.xdja.aircert.sdk.device.DeviceCache;
import com.xdja.aircert.sdk.net.HttpUrl;
import com.xdja.aircert.sdk.net.NetTimeOutInterceptor;
import com.xdja.aircert.sdk.net.ThreadHelper;
import com.xdja.aircert.sdk.util.SdkLog;
import com.xdja.cryptodev.CryptoDevInfo;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class HttpManager {
    private static final int READ_TIMEOUT = 20;
    private static final int WRITE_TIMEOUT = 20;
    private static final int CONNECTION_TIMEOUT = 20;
    private static HttpManager sInstance;
    private OkHttpClient httpClient;
    private ThreadHelper threadHelper = new ThreadHelper();

    public OkHttpClient getHttpClient() {
        if (null == this.httpClient) {
            this.initHttp();
        }
        return this.httpClient;
    }

    private HttpManager() {
        this.initHttp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpManager getInstance() {
        if (null != sInstance) return sInstance;
        Class<HttpManager> clazz = HttpManager.class;
        synchronized (HttpManager.class) {
            if (null != sInstance) return sInstance;
            sInstance = new HttpManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private void initHttp() {
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder();
        builder.connectTimeout(20L, TimeUnit.SECONDS);
        builder.readTimeout(20L, TimeUnit.SECONDS);
        builder.writeTimeout(20L, TimeUnit.SECONDS);
        builder.addInterceptor((Interceptor)new NetTimeOutInterceptor());
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, this.configHttpsAttribute(), null);
            builder.sslSocketFactory(sslContext.getSocketFactory(), new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            });
            builder.hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            this.httpClient = builder.build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private TrustManager[] configHttpsAttribute() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            return trustAllCerts;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Request initRequest(String url, String jsonStr) {
        Request.Builder builder = new Request.Builder();
        CryptoDevInfo info = DeviceCache.getsInstance().getCacheCryptoDevInfo();
        builder.addHeader("Content-Type", "application/json").addHeader("cardNo", info.cardId).addHeader("clientTime", String.valueOf(System.currentTimeMillis())).url(HttpUrl.getUrl(url));
        if (jsonStr != null) {
            MediaType mediaType = MediaType.parse((String)"application/json; charset=UTF-8");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)jsonStr);
            builder.post(body);
        }
        SdkLog.loge(url + "-------" + jsonStr);
        return builder.build();
    }

    public void executor(Runnable runnable) {
        HttpManager.getInstance().threadHelper.getExecutorService().execute(runnable);
    }

    public void executorUi(Runnable runnable) {
        HttpManager.getInstance().threadHelper.getUiThread().post(runnable);
    }
}

