/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.initvhsm.net;

import android.content.Context;
import android.os.SystemClock;
import android.text.TextUtils;
import com.xdja.initvhsm.utils.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import okio.Buffer;

public class NetManager {
    private String ip;
    private int port;
    private Context context;

    private NetManager(Context context, String ip, int port) {
        this.context = context;
        this.ip = ip;
        this.port = port;
    }

    public static NetManager create(Context context, String ip, int port) {
        if (context == null || TextUtils.isEmpty((CharSequence)ip)) {
            throw new NullPointerException("Param is null!");
        }
        NetManager netManager = new NetManager(context, ip, port);
        return netManager;
    }

    public static int connectIPAndPort(String ip, int port) {
        int ret = -1;
        if (NetManager.connect(ip, port)) {
            ret = 0;
        }
        return ret;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public byte[] send(byte[] buffer) {
        Socket socket = this.getSocket();
        return this.send(socket, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] send(Socket socket, byte[] buffer) {
        try {
            byte[] b;
            int len;
            if (socket == null) {
                return null;
            }
            socket.getOutputStream().write(buffer);
            long start = System.currentTimeMillis();
            InputStream is = socket.getInputStream();
            do {
                SystemClock.sleep((long)5L);
                long now = System.currentTimeMillis();
                long time = now - start;
                if (time <= 10000L) continue;
                return null;
            } while ((len = is.available()) < 18);
            LogUtil.log("available len = " + len);
            Buffer result = new Buffer();
            byte[] headBuffer = new byte[18];
            is.read(headBuffer);
            result.write(headBuffer);
            int dataLen = this.getIntFromBytes(Arrays.copyOfRange(headBuffer, headBuffer.length - 4, headBuffer.length));
            int sum = 0;
            int sleepTime = 0;
            byte[] tmp = new byte[4096];
            while (sum < dataLen) {
                len = is.read(tmp);
                if (len == -1) {
                    b = result.readByteArray();
                    if (sum >= dataLen) return b;
                    SystemClock.sleep((long)10L);
                    if ((sleepTime += 10) <= 5000) continue;
                    b = result.readByteArray();
                    return b;
                }
                result.write(tmp, 0, len);
                sum += len;
                sleepTime = 0;
            }
            return b;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Socket getSocket() {
        return this.getSocket(this.getIp(), this.getPort());
    }

    public Socket getSocket(String ip, int port) {
        Socket socket = new Socket();
        InetSocketAddress address = new InetSocketAddress(ip, port);
        try {
            socket.connect(address, 15000);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return socket;
    }

    private static boolean connect(String ip, int port) {
        try {
            Socket socket = new Socket();
            InetSocketAddress address = new InetSocketAddress(ip, port);
            socket.connect(address, 10000);
            socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private int getIntFromBytes(byte[] b) {
        Buffer buffer = new Buffer();
        buffer.write(b);
        return buffer.readIntLe();
    }
}

