/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.initvhsm.net;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.xdja.crypto.XDJACrypto;
import com.xdja.initvhsm.net.NetManager;
import com.xdja.initvhsm.net.bean.BindPersonParas;
import com.xdja.initvhsm.net.bean.CodeInfo;
import com.xdja.initvhsm.net.bean.DeviceInfo;
import com.xdja.initvhsm.net.bean.DeviceInformation;
import com.xdja.initvhsm.net.bean.GetVerifyTypeBean;
import com.xdja.initvhsm.net.bean.Person;
import com.xdja.initvhsm.net.bean.PersonImportInfo;
import com.xdja.initvhsm.net.bean.PersonInfo;
import com.xdja.initvhsm.net.bean.RegistParas;
import com.xdja.initvhsm.net.bean.RegisterInfo;
import com.xdja.initvhsm.net.bean.TypeStatus;
import com.xdja.initvhsm.net.bean.VerifyCodeInfo;
import com.xdja.initvhsm.net.bean.business.ApplyStatus;
import com.xdja.initvhsm.net.bean.request.BindPersonRequest;
import com.xdja.initvhsm.net.bean.request.GetCodeRequest;
import com.xdja.initvhsm.net.bean.request.GetIMEIRequest;
import com.xdja.initvhsm.net.bean.request.GetSSLCertRequest;
import com.xdja.initvhsm.net.bean.request.GetVerifyTypeRequest;
import com.xdja.initvhsm.net.bean.request.InitRequest;
import com.xdja.initvhsm.net.bean.request.NewRegisterRequest;
import com.xdja.initvhsm.net.bean.request.PersonImportRequest;
import com.xdja.initvhsm.net.bean.request.PersonRegistRequest;
import com.xdja.initvhsm.net.bean.request.QueryApplyStatusRequest;
import com.xdja.initvhsm.net.bean.request.QueryDeviceRequest;
import com.xdja.initvhsm.net.bean.request.ReInitApplyRequest;
import com.xdja.initvhsm.net.bean.request.ReInitByCodeRequest;
import com.xdja.initvhsm.net.bean.request.ReInitRequest;
import com.xdja.initvhsm.net.bean.request.RegisterRequest;
import com.xdja.initvhsm.net.bean.request.RejectRequest;
import com.xdja.initvhsm.net.bean.request.Request;
import com.xdja.initvhsm.net.bean.request.ResetPinApplyRequest;
import com.xdja.initvhsm.net.bean.request.ResetPinByCodeRequest;
import com.xdja.initvhsm.net.bean.request.ResetPinRequest;
import com.xdja.initvhsm.net.bean.request.SendRRequest;
import com.xdja.initvhsm.net.bean.request.UnlockApplyRequest;
import com.xdja.initvhsm.net.bean.request.UnlockByCodeRequest;
import com.xdja.initvhsm.net.bean.request.UnlockRequest;
import com.xdja.initvhsm.net.bean.request.VerifyCodeRequest;
import com.xdja.initvhsm.net.bean.response.BindPersonResponse;
import com.xdja.initvhsm.net.bean.response.GetCodeReponse;
import com.xdja.initvhsm.net.bean.response.GetIMEIResponse;
import com.xdja.initvhsm.net.bean.response.GetSSLCertResponse;
import com.xdja.initvhsm.net.bean.response.GetVerifyTypeResponse;
import com.xdja.initvhsm.net.bean.response.InitResponse;
import com.xdja.initvhsm.net.bean.response.NewRegisterResponse;
import com.xdja.initvhsm.net.bean.response.PersonImportResponse;
import com.xdja.initvhsm.net.bean.response.PersonRegistResponse;
import com.xdja.initvhsm.net.bean.response.QueryApplyStatusResponse;
import com.xdja.initvhsm.net.bean.response.QueryDeviceResponse;
import com.xdja.initvhsm.net.bean.response.ReInitApplyResponse;
import com.xdja.initvhsm.net.bean.response.ReInitByCodeResponse;
import com.xdja.initvhsm.net.bean.response.ReInitResponse;
import com.xdja.initvhsm.net.bean.response.RegisterResponse;
import com.xdja.initvhsm.net.bean.response.RejectResponse;
import com.xdja.initvhsm.net.bean.response.ResetPinApplyResponse;
import com.xdja.initvhsm.net.bean.response.ResetPinByCodeResponse;
import com.xdja.initvhsm.net.bean.response.ResetPinResponse;
import com.xdja.initvhsm.net.bean.response.Response;
import com.xdja.initvhsm.net.bean.response.SendRResponse;
import com.xdja.initvhsm.net.bean.response.UnlockApplyResponse;
import com.xdja.initvhsm.net.bean.response.UnlockByCodeResponse;
import com.xdja.initvhsm.net.bean.response.UnlockResponse;
import com.xdja.initvhsm.net.bean.response.VerifyCodeResponse;
import com.xdja.initvhsm.utils.EncDecData;
import com.xdja.initvhsm.utils.FileUtil;
import com.xdja.initvhsm.utils.LogUtil;
import com.xdja.initvhsm.utils.NetVhsmFileUtil;
import com.xdja.initvhsm.utils.RandomUtil;
import com.xdja.initvhsm.utils.VHSMBroadcast;
import com.xdja.xdjacrypto.SM2PublicKey;
import com.xdja.xdjacrypto.XCT_CERT_INFO;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import okio.Buffer;

public class NetRespository {
    public static final String TAG = "NetTag";
    private Context context;
    private NetManager netManager;
    private static byte[] rightCert = null;
    private static SM2PublicKey sm2PubKey = null;

    private NetRespository() {
    }

    private NetRespository(Context context, String ip, int port) {
        this.context = context;
        this.netManager = NetManager.create(context, ip, port);
    }

    public static NetRespository create(Context context, String ip, int port) {
        if (context == null || TextUtils.isEmpty((CharSequence)ip)) {
            throw new NullPointerException("Param is null!");
        }
        LogUtil.setContext(context);
        NetRespository instance = new NetRespository(context, ip, port);
        return instance;
    }

    public Pair<Integer, DeviceInfo> queryDevice(String deviceId) {
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            return Pair.create((Object)-10003, null);
        }
        QueryDeviceRequest request = new QueryDeviceRequest(deviceId);
        QueryDeviceResponse response = new QueryDeviceResponse();
        Pair<Integer, QueryDeviceResponse> pair = this.sslConnectSend(deviceId, request, response);
        if ((Integer)pair.first != 0) {
            return Pair.create((Object)pair.first, null);
        }
        response = (QueryDeviceResponse)pair.second;
        return Pair.create((Object)0, (Object)response.deviceInfo);
    }

    public int registerInfo(RegisterInfo info) {
        if (info == null) {
            return -10003;
        }
        RegisterRequest request = new RegisterRequest(info);
        RegisterResponse response = new RegisterResponse();
        Pair<Integer, RegisterResponse> pair = this.sslConnectSend(info.sn, request, response);
        return (Integer)pair.first;
    }

    public int registerInfo(DeviceInformation deviceInformation, Person person) {
        if (deviceInformation == null || person == null) {
            return -10003;
        }
        RegistParas registParas = new RegistParas();
        registParas.device = deviceInformation;
        registParas.person = person;
        NewRegisterRequest request = new NewRegisterRequest(registParas);
        NewRegisterResponse response = new NewRegisterResponse();
        Pair<Integer, NewRegisterResponse> pair = this.sslConnectSend(deviceInformation.sn, request, response);
        return (Integer)pair.first;
    }

    public int init(String deviceId) {
        InitRequest request = new InitRequest(deviceId);
        InitResponse response = new InitResponse();
        return this.initPri(deviceId, request, response);
    }

    public int reInit(String deviceId) {
        ReInitRequest request = new ReInitRequest(deviceId);
        ReInitResponse response = new ReInitResponse();
        return this.initPri(deviceId, request, response);
    }

    public int initDirct(String deviceId, PersonImportInfo personImportInfo) {
        PersonImportRequest personImportRequest = new PersonImportRequest(personImportInfo);
        PersonImportResponse personImportResponse = new PersonImportResponse();
        return this.initPri(deviceId, personImportRequest, personImportResponse);
    }

    private int initPri(String deviceId, Request request, InitResponse response) {
        if (TextUtils.isEmpty((CharSequence)deviceId) || this.context == null) {
            Log.e((String)TAG, (String)"deviceId is null!");
            return -10003;
        }
        File randFile = NetVhsmFileUtil.getRandFile(this.context.getApplicationContext());
        File wboxFile = NetVhsmFileUtil.getWboxFile(this.context.getApplicationContext());
        File kdatFile = NetVhsmFileUtil.getKdatFile(this.context.getApplicationContext());
        File donaFile = NetVhsmFileUtil.getInitConfigFile(this.context.getApplicationContext());
        Pair<Integer, InitResponse> pair = this.sslConnectSend(deviceId, request, response);
        if ((Integer)pair.first != 0) {
            this.delAllInitFile(this.context);
            return (Integer)pair.first;
        }
        response = (InitResponse)pair.second;
        int ret = FileUtil.writeToFile(randFile, response.getRandData());
        if (ret != 0) {
            this.delAllInitFile(this.context);
            return -10004;
        }
        ret = FileUtil.writeToFile(wboxFile, response.getWboxData());
        if (ret != 0) {
            this.delAllInitFile(this.context);
            return -10004;
        }
        ret = FileUtil.writeToFile(kdatFile, response.getKdatData());
        if (ret != 0) {
            this.delAllInitFile(this.context);
            return -10004;
        }
        ret = FileUtil.writeToFile(donaFile, response.getDonaData());
        if (ret != 0) {
            this.delAllInitFile(this.context);
            return -10004;
        }
        VHSMBroadcast.sendVHSMBrocast(this.context, 0);
        return 0;
    }

    private void delAllInitFile(Context context) {
        File randFile = NetVhsmFileUtil.getRandFile(context.getApplicationContext());
        File wboxFile = NetVhsmFileUtil.getWboxFile(context.getApplicationContext());
        File kdatFile = NetVhsmFileUtil.getKdatFile(context.getApplicationContext());
        if (randFile != null) {
            randFile.delete();
        }
        if (wboxFile != null) {
            wboxFile.delete();
        }
        if (kdatFile != null) {
            kdatFile.delete();
        }
        VHSMBroadcast.sendVHSMBrocast(context, -1);
    }

    public int reInitApply(String deviceId) {
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            Log.e((String)TAG, (String)"deviceId is null!");
            return -10003;
        }
        ReInitApplyRequest request = new ReInitApplyRequest(deviceId);
        ReInitApplyResponse response = new ReInitApplyResponse();
        Pair<Integer, ReInitApplyResponse> pair = this.sslConnectSend(deviceId, request, response);
        return (Integer)pair.first;
    }

    public Pair<Integer, ArrayList<TypeStatus>> queryApplyStatus(String deviceId) {
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            return Pair.create((Object)-10003, null);
        }
        QueryApplyStatusRequest request = new QueryApplyStatusRequest(deviceId);
        QueryApplyStatusResponse response = new QueryApplyStatusResponse();
        Pair<Integer, QueryApplyStatusResponse> pair = this.sslConnectSend(deviceId, request, response);
        if ((Integer)pair.first != 0) {
            return Pair.create((Object)pair.first, null);
        }
        response = (QueryApplyStatusResponse)pair.second;
        return Pair.create((Object)0, response.getTypeStatusList());
    }

    public Pair<Integer, ApplyStatus> queryApplyStatusNew(String deviceId) {
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            return Pair.create((Object)-10003, null);
        }
        QueryApplyStatusRequest request = new QueryApplyStatusRequest(deviceId);
        QueryApplyStatusResponse response = new QueryApplyStatusResponse();
        Pair<Integer, QueryApplyStatusResponse> pair = this.sslConnectSend(deviceId, request, response);
        if ((Integer)pair.first != 0) {
            return Pair.create((Object)pair.first, null);
        }
        response = (QueryApplyStatusResponse)pair.second;
        ApplyStatus applyStatus = new ApplyStatus();
        ArrayList<TypeStatus> typeStatusList = response.getTypeStatusList();
        for (TypeStatus status : typeStatusList) {
            switch (status.type) {
                case 1: {
                    applyStatus.deviceRegisterApply = status.status;
                    break;
                }
                case 2: {
                    applyStatus.reInitApply = status.status;
                    break;
                }
                case 3: {
                    applyStatus.unlockApply = status.status;
                    break;
                }
                case 4: {
                    applyStatus.forgetPinApply = status.status;
                    break;
                }
                case 5: {
                    applyStatus.persionRegisterApply = status.status;
                    break;
                }
            }
        }
        return Pair.create((Object)0, (Object)applyStatus);
    }

    public int unlockApply(String deviceId) {
        UnlockApplyRequest request = new UnlockApplyRequest(deviceId);
        UnlockApplyResponse response = new UnlockApplyResponse();
        Pair<Integer, UnlockApplyResponse> pair = this.sslConnectSend(deviceId, request, response);
        return (Integer)pair.first;
    }

    public int unlock(String deviceId) {
        UnlockRequest request = new UnlockRequest(deviceId);
        UnlockResponse response = new UnlockResponse();
        Pair<Integer, UnlockResponse> pair = this.sslConnectSend(deviceId, request, response);
        if ((Integer)pair.first != 0) {
            return (Integer)pair.first;
        }
        response = (UnlockResponse)pair.second;
        File wboxFile = NetVhsmFileUtil.getWboxFile(this.context.getApplicationContext());
        int ret = FileUtil.writeToFile(wboxFile, response.getWbox());
        if (ret != 0) {
            wboxFile.delete();
            return ret;
        }
        return ret;
    }

    public int resetPinApply(String deviceId) {
        ResetPinApplyRequest request = new ResetPinApplyRequest(deviceId);
        ResetPinApplyResponse response = new ResetPinApplyResponse();
        Pair<Integer, ResetPinApplyResponse> pair = this.sslConnectSend(deviceId, request, response);
        return (Integer)pair.first;
    }

    public int resetPin(String deviceId) {
        ResetPinRequest request = new ResetPinRequest(deviceId);
        ResetPinResponse response = new ResetPinResponse();
        Pair<Integer, ResetPinResponse> pair = this.sslConnectSend(deviceId, request, response);
        if ((Integer)pair.first != 0) {
            return (Integer)pair.first;
        }
        response = (ResetPinResponse)pair.second;
        File wboxFile = NetVhsmFileUtil.getWboxFile(this.context.getApplicationContext());
        int ret = FileUtil.writeToFile(wboxFile, response.getWbox());
        if (ret != 0) {
            wboxFile.delete();
            return ret;
        }
        return ret;
    }

    public static int initVhsmlibFile(Context context, String ip, int port) {
        byte[] configData;
        NetRespository instance = new NetRespository();
        File configFile = NetVhsmFileUtil.getInitConfigFile(context);
        if (configFile == null) {
            Log.e((String)"VhsmInit", (String)"config create fail");
            return -10004;
        }
        if (configFile.exists()) {
            configFile.delete();
        }
        if ((configData = instance.getConfigStr(ip, port)) == null) {
            Log.e((String)"VhsmInit", (String)"getConfigStr is null");
            return -10004;
        }
        int ret = FileUtil.writeToFile(configFile, configData);
        if (ret == 0) {
            configFile.setReadOnly();
        }
        return ret;
    }

    public static int initVhsmIMEICfgFile(Context context, String androidId, String imei) {
        byte[] configData;
        NetRespository instance = new NetRespository();
        File configFile = NetVhsmFileUtil.getIMEICfgFile(context);
        if (configFile == null) {
            Log.e((String)"VhsmInit", (String)"config create fail");
            return -10011;
        }
        if (configFile.exists()) {
            configFile.delete();
        }
        if ((configData = instance.getIMEIConfigStr(androidId, imei)) == null) {
            Log.e((String)"VhsmInit", (String)"getConfigStr is null");
            return -10004;
        }
        int ret = FileUtil.writeToFile(configFile, configData);
        if (ret == 0) {
            configFile.setReadOnly();
        }
        return ret;
    }

    public int bindPerson(DeviceInformation device, String mobile, String code) {
        if (device == null || TextUtils.isEmpty((CharSequence)mobile) || TextUtils.isEmpty((CharSequence)code)) {
            return -10003;
        }
        BindPersonParas bindPersonParas = new BindPersonParas();
        bindPersonParas.device = device;
        bindPersonParas.mobile = mobile;
        bindPersonParas.code = code;
        BindPersonRequest request = new BindPersonRequest(bindPersonParas);
        BindPersonResponse response = new BindPersonResponse();
        Pair<Integer, BindPersonResponse> pair = this.sslConnectSend(device.sn, request, response);
        return (Integer)pair.first;
    }

    public int getCode(String deviceId, String mobile, String codeTemplateType) {
        if (TextUtils.isEmpty((CharSequence)deviceId) || TextUtils.isEmpty((CharSequence)mobile)) {
            Log.e((String)TAG, (String)"deviceId  or mobile is null!");
            return -10003;
        }
        CodeInfo codeInfo = new CodeInfo();
        codeInfo.id = deviceId;
        codeInfo.mobile = mobile;
        codeInfo.type = codeTemplateType;
        GetCodeRequest request = new GetCodeRequest(codeInfo);
        GetCodeReponse response = new GetCodeReponse();
        Pair<Integer, GetCodeReponse> pair = this.sslConnectSend(deviceId, request, response);
        return (Integer)pair.first;
    }

    public int verifyCode(String deviceId, String mobile, String code) {
        if (TextUtils.isEmpty((CharSequence)deviceId) || TextUtils.isEmpty((CharSequence)mobile) || TextUtils.isEmpty((CharSequence)code)) {
            Log.e((String)TAG, (String)"deviceId  or  mobile or code is null!");
            return -10003;
        }
        VerifyCodeInfo verifyCodeInfo = new VerifyCodeInfo();
        verifyCodeInfo.id = deviceId;
        verifyCodeInfo.mobile = mobile;
        verifyCodeInfo.code = code;
        VerifyCodeRequest request = new VerifyCodeRequest(verifyCodeInfo);
        VerifyCodeResponse response = new VerifyCodeResponse();
        Pair<Integer, VerifyCodeResponse> pair = this.sslConnectSend(deviceId, request, response);
        return (Integer)pair.first;
    }

    public int registPersonInfo(PersonInfo personInfo) {
        if (personInfo == null) {
            Log.e((String)TAG, (String)"sn,name or mobile is null!");
            return -10003;
        }
        PersonRegistRequest request = new PersonRegistRequest(personInfo);
        PersonRegistResponse response = new PersonRegistResponse();
        Pair<Integer, PersonRegistResponse> pair = this.sslConnectSend(personInfo.deviceSn, request, response);
        return (Integer)pair.first;
    }

    public int sendRejectRequest(String deviceId, int applyType) {
        RejectRequest rejectRequest = new RejectRequest(deviceId, applyType);
        RejectResponse rejectResponse = new RejectResponse();
        Pair<Integer, RejectResponse> pair = this.sslConnectSend(deviceId, rejectRequest, rejectResponse);
        return (Integer)pair.first;
    }

    public Pair<Integer, String[]> getAllIMEIsFromIdentity(String deviceId, String identity) {
        GetIMEIRequest getIMEIRequest = new GetIMEIRequest(identity);
        GetIMEIResponse getIMEIResponse = new GetIMEIResponse();
        Pair<Integer, GetIMEIResponse> pair = this.sslConnectSend(deviceId, getIMEIRequest, getIMEIResponse);
        return Pair.create((Object)pair.first, (Object)((GetIMEIResponse)pair.second).getAllIMEIs());
    }

    public Pair<Integer, GetVerifyTypeBean> getVerifyType(String deviceId) {
        GetVerifyTypeRequest getVerifyTypeRequest = new GetVerifyTypeRequest(deviceId);
        GetVerifyTypeResponse getVerifyTypeResponse = new GetVerifyTypeResponse();
        Pair<Integer, GetVerifyTypeResponse> pair = this.sslConnectSend(deviceId, getVerifyTypeRequest, getVerifyTypeResponse);
        if ((Integer)pair.first == 0) {
            GetVerifyTypeBean getVerifyTypeBean = new GetVerifyTypeBean();
            getVerifyTypeBean.mobile = ((GetVerifyTypeResponse)pair.second).getMobile();
            getVerifyTypeBean.verify = ((GetVerifyTypeResponse)pair.second).getVerifyType();
            return Pair.create((Object)0, (Object)getVerifyTypeBean);
        }
        return Pair.create((Object)pair.first, null);
    }

    public int resetPinByCode(String deviceId, String code, String mobile) {
        ResetPinByCodeRequest request = new ResetPinByCodeRequest(deviceId, code, mobile);
        ResetPinByCodeResponse response = new ResetPinByCodeResponse();
        Pair<Integer, ResetPinByCodeResponse> pair = this.sslConnectSend(deviceId, request, response);
        if ((Integer)pair.first != 0) {
            return (Integer)pair.first;
        }
        response = (ResetPinByCodeResponse)pair.second;
        File wboxFile = NetVhsmFileUtil.getWboxFile(this.context.getApplicationContext());
        int ret = FileUtil.writeToFile(wboxFile, response.getWbox());
        if (ret != 0) {
            wboxFile.delete();
            return ret;
        }
        return ret;
    }

    public int unlockByCode(String deviceId, String code, String mobile) {
        UnlockByCodeRequest request = new UnlockByCodeRequest(deviceId, code, mobile);
        UnlockByCodeResponse response = new UnlockByCodeResponse();
        Pair<Integer, UnlockByCodeResponse> pair = this.sslConnectSend(deviceId, request, response);
        if ((Integer)pair.first != 0) {
            return (Integer)pair.first;
        }
        response = (UnlockByCodeResponse)pair.second;
        File wboxFile = NetVhsmFileUtil.getWboxFile(this.context.getApplicationContext());
        int ret = FileUtil.writeToFile(wboxFile, response.getWbox());
        if (ret != 0) {
            wboxFile.delete();
            return ret;
        }
        return ret;
    }

    public int reInitByCode(String deviceId, String code, String mobile) {
        ReInitByCodeRequest request = new ReInitByCodeRequest(deviceId, code, mobile);
        ReInitByCodeResponse response = new ReInitByCodeResponse();
        return this.initPri(deviceId, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readRootCertFromAssets() {
        BufferedInputStream bis = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int readLen;
            bis = new BufferedInputStream(this.context.getAssets().open("SubCa_sm2.cer"));
            byte[] buffer = new byte[256];
            while ((readLen = bis.read(buffer)) > 0) {
                bos.write(buffer, 0, readLen);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bos.toByteArray();
    }

    private Pair<Integer, byte[]> sslConnect(Socket socket, String deviceId) {
        Pair<Integer, byte[]> pair = this.getSSLCert(socket);
        if ((Integer)pair.first != 0) {
            return Pair.create((Object)pair.first, null);
        }
        byte[] cert = (byte[])pair.second;
        Pair<Integer, SM2PublicKey> verifyCertPair = this.verifyCertAndGetPubKey(cert);
        if ((Integer)verifyCertPair.first != 0) {
            return Pair.create((Object)verifyCertPair.first, null);
        }
        SM2PublicKey sm2PublicKey = (SM2PublicKey)verifyCertPair.second;
        byte[] r = RandomUtil.getRandomFromDevRandom(16);
        pair = this.sendR(socket, sm2PublicKey, r, deviceId);
        if ((Integer)pair.first != 0) {
            return Pair.create((Object)pair.first, null);
        }
        byte[] tag = (byte[])pair.second;
        String result = new String(tag);
        if (result.equals("success")) {
            return Pair.create((Object)0, (Object)r);
        }
        return Pair.create((Object)-10009, null);
    }

    private Pair<Integer, byte[]> getEncryptR(SM2PublicKey sm2PublicKey, byte[] r, String deviceId) {
        Buffer buffer = new Buffer();
        buffer.write(r);
        buffer.write(deviceId.getBytes());
        byte[] source = buffer.readByteArray();
        byte[] to = new byte[256];
        int[] tLen = new int[1];
        int ret = XDJACrypto.getInstance().SM2PublicEncrypt(sm2PublicKey, source, source.length, to, tLen);
        if (ret != 0) {
            return Pair.create((Object)ret, null);
        }
        byte[] R = Arrays.copyOf(to, tLen[0]);
        return Pair.create((Object)0, (Object)R);
    }

    public Pair<Integer, byte[]> getSSLCert(Socket socket) {
        GetSSLCertRequest getSSLCertRequest = new GetSSLCertRequest();
        byte[] result = this.netManager.send(socket, getSSLCertRequest.toBytes());
        GetSSLCertResponse getSSLCertResponse = new GetSSLCertResponse();
        boolean flag = getSSLCertResponse.parse(result);
        int code = 0;
        if (!flag) {
            code = getSSLCertResponse.getErrorCode();
            return Pair.create((Object)code, null);
        }
        return Pair.create((Object)code, (Object)getSSLCertResponse.getCert());
    }

    public Pair<Integer, byte[]> sendR(Socket socket, SM2PublicKey sm2PublicKey, byte[] r, String deviceId) {
        Pair<Integer, byte[]> pair = this.getEncryptR(sm2PublicKey, r, deviceId);
        if ((Integer)pair.first != 0) {
            return Pair.create((Object)pair.first, null);
        }
        SendRRequest sendRRequest = new SendRRequest((byte[])pair.second);
        SendRResponse sendRResponse = new SendRResponse();
        byte[] receiveBuffer = this.netManager.send(socket, sendRRequest.toBytes());
        if (receiveBuffer == null) {
            return Pair.create((Object)-10005, null);
        }
        byte[] encData = sendRResponse.getOnlyData(receiveBuffer);
        pair = EncDecData.decData(r, encData);
        if ((Integer)pair.first != 0) {
            return Pair.create((Object)pair.first, null);
        }
        Buffer b = new Buffer();
        b.write(Arrays.copyOf(receiveBuffer, receiveBuffer.length - encData.length - 4));
        b.writeIntLe(((byte[])pair.second).length);
        b.write((byte[])pair.second);
        boolean flag = sendRResponse.parse(b.readByteArray());
        int code = 0;
        if (!flag) {
            code = sendRResponse.getErrorCode();
            return Pair.create((Object)code, null);
        }
        return Pair.create((Object)code, (Object)sendRResponse.getTag());
    }

    private byte[] getConfigStr(String ip, int port) {
        String configStr_raw = String.format(Locale.getDefault(), "ip=%s#port=%d#", ip, port);
        byte[] plainDataBytes_raw = configStr_raw.getBytes();
        byte[] dataFill = this.dataFill(plainDataBytes_raw);
        byte[] dataAfterEnc = new byte[dataFill.length];
        byte[] flag = this.getFlag();
        int ret = XDJACrypto.getInstance().SM4New(flag, 1, dataFill, dataFill.length, dataAfterEnc, null);
        Log.e((String)"VhsmInit", (String)("config enc fail ret: " + ret));
        if (ret == 0) {
            return dataAfterEnc;
        }
        return null;
    }

    private byte[] getIMEIConfigStr(String androidId, String imei) {
        byte[] plainDataBytes_raw = imei.getBytes();
        byte[] dataFill = this.dataFill(plainDataBytes_raw);
        byte[] dataAfterEnc = new byte[dataFill.length];
        byte[] flag = androidId.getBytes();
        int ret = XDJACrypto.getInstance().SM4(flag, 1, dataFill, dataFill.length, dataAfterEnc, null);
        Log.e((String)"IMEIConfig", (String)("config enc fail ret: " + ret));
        if (ret == 0) {
            return dataAfterEnc;
        }
        return null;
    }

    private byte[] dataFill(byte[] data) {
        int padLen = data.length % 16;
        if (padLen == 0) {
            return data;
        }
        padLen = 16 - padLen;
        int len = data.length + padLen;
        byte[] result = new byte[len];
        Arrays.fill(result, (byte)0);
        System.arraycopy(data, 0, result, 0, data.length);
        return result;
    }

    private byte[] getFlag() {
        int i;
        StringBuilder flag = new StringBuilder();
        for (i = 1; i <= 8; ++i) {
            flag.append(i);
        }
        for (i = 1; i <= 8; ++i) {
            flag.append(i);
        }
        return flag.toString().getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Request, S extends Response> Pair<Integer, S> sslConnectSend(String deviceId, T request, S response) {
        Socket socket = this.netManager.getSocket();
        if (socket == null) {
            return Pair.create((Object)-10005, null);
        }
        try {
            Pair<Integer, byte[]> pair = this.sslConnect(socket, deviceId);
            if ((Integer)pair.first != 0) {
                Pair pair2 = Pair.create((Object)pair.first, null);
                return pair2;
            }
            byte[] key = (byte[])pair.second;
            pair = EncDecData.encData(key, request.getData());
            if ((Integer)pair.first != 0) {
                Pair e = Pair.create((Object)pair.first, null);
                return e;
            }
            byte[] params = request.toBytesUseEncData((byte[])pair.second);
            byte[] receiveBuffer = this.netManager.send(socket, params);
            byte[] encData = response.getOnlyData(receiveBuffer);
            if (encData == null) {
                Pair pair3 = Pair.create((Object)-10001, null);
                return pair3;
            }
            pair = EncDecData.decData(key, encData);
            if ((Integer)pair.first != 0) {
                Pair pair4 = Pair.create((Object)pair.first, null);
                return pair4;
            }
            Buffer b = new Buffer();
            b.write(Arrays.copyOf(receiveBuffer, receiveBuffer.length - encData.length - 4));
            b.writeIntLe(((byte[])pair.second).length);
            b.write((byte[])pair.second);
            boolean parse = response.parse(b.readByteArray());
            if (!parse) {
                Pair pair5 = Pair.create((Object)response.getErrorCode(), null);
                return pair5;
            }
            Pair pair6 = Pair.create((Object)0, response);
            return pair6;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private Pair<Integer, SM2PublicKey> verifyCertAndGetPubKey(byte[] cert) {
        byte[] pubkey;
        boolean equals = Arrays.equals(cert, rightCert);
        if (equals && sm2PubKey != null) {
            return Pair.create((Object)0, (Object)sm2PubKey);
        }
        byte[] cabuf = this.readRootCertFromAssets();
        int ret = XDJACrypto.getInstance().CaVerifyUerCert(cabuf, cabuf.length, cert, cert.length);
        if (ret != 0) {
            return Pair.create((Object)-10007, null);
        }
        XCT_CERT_INFO cert_info = new XCT_CERT_INFO();
        ret = XDJACrypto.getInstance().GetCertInfo(cert, cert.length, cert_info);
        if (ret != 0) {
            return Pair.create((Object)-10008, null);
        }
        rightCert = Arrays.copyOf(cert, cert.length);
        if (cert_info.pubkey_len == 65) {
            pubkey = Arrays.copyOfRange(cert_info.pubkey, 1, 65);
        } else if (cert_info.pubkey_len == 64) {
            pubkey = Arrays.copyOf(cert_info.pubkey, 64);
        } else if (cert_info.pubkey_len == 63) {
            pubkey = new byte[64];
            System.arraycopy(cert_info.pubkey, 0, pubkey, 1, 63);
        } else {
            return Pair.create((Object)-10008, null);
        }
        sm2PubKey = new SM2PublicKey();
        NetRespository.sm2PubKey.bits = 256;
        System.arraycopy(pubkey, 0, NetRespository.sm2PubKey.x, 0, 32);
        System.arraycopy(pubkey, 32, NetRespository.sm2PubKey.y, 0, 32);
        return Pair.create((Object)0, (Object)sm2PubKey);
    }
}

