/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.initvhsm.net.bean.response;

import com.xdja.initvhsm.utils.ConvertUtil;
import java.io.EOFException;
import java.util.Arrays;
import okio.Buffer;

public abstract class Response {
    public static final byte[] ERROR = "error".getBytes();
    public static final int ERROR_LEN = 9;
    public static final byte[] HEAD = "VHSM".getBytes();
    public byte[] flag;
    public byte[] version;
    public byte[] seriesNumber;
    public int dataLen;
    public byte[] data;
    public int errorCode = -1;

    protected abstract byte[] reallyFlag();

    public int getErrorCode() {
        return this.errorCode;
    }

    public byte[] getOnlyData(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            return null;
        }
        try {
            int start = 14;
            int end = start + 4;
            byte[] lenBytes = Arrays.copyOfRange(buffer, start, end);
            int len = ConvertUtil.bytesToIntLe(lenBytes);
            start = end;
            end = len + end;
            byte[] result = Arrays.copyOfRange(buffer, start, end);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean parse(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            this.errorCode = -10005;
            return false;
        }
        Buffer b = new Buffer();
        b.write(buffer);
        try {
            byte[] head = b.readByteArray(4L);
            String headStr = new String(head);
            if (!Arrays.equals(head, HEAD)) {
                this.errorCode = -10002;
                return false;
            }
            this.flag = b.readByteArray(2L);
            if (!Arrays.equals(this.flag, this.reallyFlag())) {
                this.errorCode = -10002;
                return false;
            }
            this.version = b.readByteArray(4L);
            this.seriesNumber = b.readByteArray(4L);
            this.dataLen = b.readIntLe();
            if ((long)this.dataLen > b.size()) {
                this.errorCode = -10001;
                return false;
            }
            this.data = b.readByteArray((long)this.dataLen);
            if (this.dataLen == 9 && Arrays.equals(Arrays.copyOf(this.data, ERROR.length), ERROR)) {
                Buffer eb = new Buffer();
                eb.write(this.data);
                eb.readByteArray((long)ERROR.length);
                this.errorCode = eb.readIntLe();
                return false;
            }
        }
        catch (EOFException e) {
            e.printStackTrace();
            this.errorCode = -10001;
            return false;
        }
        return true;
    }
}

