package com.xdja.aircert.sdk.net;

import android.text.TextUtils;

import com.xdja.aircert.sdk.AirCertSdk;
import com.xdja.aircert.sdk.util.SdkLog;

import java.net.InetSocketAddress;
import java.net.Socket;

/**
 * @author: lyl
 * desc:
 * 2020/11/5
 */
public class HttpUrl {
    public static final String APPLY = "/airIssue-api/v1/cert/application";
    public static final String CERT_STATUS = "/airIssue-api/v1/cert/status";
    public static final String IDENTITY_PHONE = "/airIssue-api/v1/identity/phone";
    public static final String IDENTITY_AUTH = "/airIssue-api/v1/identify/authentication";
    public static final String WRITE_STATUS = "/airIssue-api/v1/cert/write";
    public static final String REVOKE = "/airIssue-api/v1/cert/revoke";
    private static String connectedBaseUrl;
    private static String baseVhsmUrl;

    static String getUrl(String url) {
        String baseUrl;
        if (TextUtils.isEmpty(connectedBaseUrl)) {
            connectedBaseUrl = telnetAddress(AirCertSdk.getsInstance().getAirCertConfig().getServerAddress());
        }
        baseUrl = "https://" + connectedBaseUrl;
        String tail = String.valueOf(baseUrl.charAt(baseUrl.length() - 1));
        if ("/".equals(tail)) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        SdkLog.loge("server url"+baseUrl);
        return baseUrl + url;
    }

    public static String getVhsmAddress() {
        if (TextUtils.isEmpty(baseVhsmUrl)) {
            baseVhsmUrl = telnetAddress(AirCertSdk.getsInstance().getAirCertConfig().getVhsmIpPort());
            SdkLog.loge("vhsm url"+baseVhsmUrl);
            return baseVhsmUrl;
        }
        SdkLog.loge("vhsm url"+baseVhsmUrl);
        return baseVhsmUrl;
    }

    static void useTelnet() {
        connectedBaseUrl = "";
        baseVhsmUrl = "";
    }

    /**
     * @return
     */
    private static String telnetAddress(String address) {
        if (address.contains("|")) {
            String[] addresses = address.split("\\|");
            for (String url : addresses) {
                try (Socket socket = new Socket()) {
                    String[] ipPort = url.split(":");
                    socket.connect(new InetSocketAddress(ipPort[0], Integer.parseInt(ipPort[1])), 3000);
                    return url;
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return addresses[0];
        }
        return address;
    }
}
