/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.sdk.config;

import android.text.TextUtils;
import com.xdja.aircert.sdk.config.AirCertConstant;

public final class AirCertConfig {
    private String serverAddress;
    private String vhsmIpPort;
    private int containerNum;
    @AirCertConstant.DEV_TYPE
    private int cardType;
    @AirCertConstant.ALG_TYPE
    private int algType;
    @AirCertConstant.CERT_TYPE
    private String certType;
    private String rootCertName;

    private AirCertConfig(Builder builder) {
        this.serverAddress = builder.serverAddress;
        this.vhsmIpPort = builder.vhsmIpPort;
        this.containerNum = builder.containerNum;
        this.cardType = builder.cardType == 0 ? 4 : builder.cardType;
        this.algType = builder.algType == 0 ? 1 : builder.algType;
        this.certType = TextUtils.isEmpty((CharSequence)builder.certType) ? "\u7b7e\u540d\u8bc1\u4e66" : builder.certType;
        this.rootCertName = TextUtils.isEmpty((CharSequence)builder.rootCertName) ? "root.cer" : builder.rootCertName;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getVhsmIpPort() {
        return this.vhsmIpPort;
    }

    public int getContainerNum() {
        return this.containerNum;
    }

    public int getCardType() {
        return this.cardType;
    }

    public int getAlgType() {
        return this.algType;
    }

    public String getCertType() {
        return this.certType;
    }

    public String getRootCertName() {
        return this.rootCertName;
    }

    public static class Builder {
        private String serverAddress;
        private String vhsmIpPort;
        private int containerNum;
        @AirCertConstant.DEV_TYPE
        private int cardType;
        @AirCertConstant.ALG_TYPE
        private int algType;
        @AirCertConstant.CERT_TYPE
        private String certType;
        private String rootCertName;

        public void setRootCertName(String rootCertName) {
            this.rootCertName = rootCertName;
        }

        public Builder setServerAddress(String serverAddress) {
            if (TextUtils.isEmpty((CharSequence)serverAddress)) {
                throw new IllegalArgumentException("serverAddress == null");
            }
            this.serverAddress = serverAddress;
            return this;
        }

        public Builder setVhsmIpPort(String vhsmIpPort) {
            if (TextUtils.isEmpty((CharSequence)vhsmIpPort)) {
                throw new IllegalArgumentException("vhsmAddress == null");
            }
            this.vhsmIpPort = vhsmIpPort;
            return this;
        }

        public Builder setContainerNum(int containerNum) {
            this.containerNum = containerNum;
            return this;
        }

        public Builder setCardType(@AirCertConstant.DEV_TYPE int cardType) {
            this.cardType = cardType;
            return this;
        }

        public Builder setAlgType(@AirCertConstant.ALG_TYPE int algType) {
            this.algType = algType;
            return this;
        }

        public Builder setCertType(@AirCertConstant.CERT_TYPE String certType) {
            this.certType = certType;
            return this;
        }

        public AirCertConfig build() {
            if (TextUtils.isEmpty((CharSequence)this.serverAddress)) {
                throw new IllegalArgumentException("serverAddress == null");
            }
            if (TextUtils.isEmpty((CharSequence)this.vhsmIpPort)) {
                throw new IllegalArgumentException("vhsmAddress == null");
            }
            return new AirCertConfig(this);
        }
    }
}

