/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.sdk.data;

import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.xdja.aircert.sdk.AirCertSdk;
import com.xdja.aircert.sdk.bean.CertApplyBean;
import com.xdja.aircert.sdk.bean.CertDetailInfoBean;
import com.xdja.aircert.sdk.bean.CommonResponse;
import com.xdja.aircert.sdk.bean.RevokedCertBean;
import com.xdja.aircert.sdk.bean.VerifyInfoBean;
import com.xdja.aircert.sdk.bean.WriteFailBean;
import com.xdja.aircert.sdk.cert.PKCS10Utils;
import com.xdja.aircert.sdk.data.HttpCallBack;
import com.xdja.aircert.sdk.device.CertHelper;
import com.xdja.aircert.sdk.device.DeviceCache;
import com.xdja.aircert.sdk.device.DeviceWrapper;
import com.xdja.aircert.sdk.device.NetVHSMHandle;
import com.xdja.aircert.sdk.device.OperateCertHelper;
import com.xdja.aircert.sdk.net.HttpManager;
import com.xdja.aircert.sdk.net.HttpUrl;
import com.xdja.aircert.sdk.net.Params;
import com.xdja.aircert.sdk.util.ResponseUtil;
import com.xdja.aircert.sdk.util.SdkLog;
import com.xdja.cryptodev.CryptoDevManager;
import java.io.IOException;
import okhttp3.Request;
import okhttp3.Response;
import org.json.JSONObject;

class CertRepository {
    CertRepository() {
    }

    static void applyCert(String phone, HttpCallBack<CertDetailInfoBean> callBack) {
        try {
            if (CertRepository.verifyCert()) {
                CertRepository.success(callBack, CertHelper.readCertInfo());
                return;
            }
            JSONObject object = new JSONObject();
            object.put("phone", (Object)phone);
            Request requestBody = HttpManager.initRequest("/airIssue-api/v1/identity/phone", object.toString());
            Response response = HttpManager.getInstance().getHttpClient().newCall(requestBody).execute();
            if (!response.isSuccessful()) {
                CertRepository.error(callBack, 43, "phone net identity error");
                return;
            }
            SdkLog.logi("\u624b\u673a\u53f7\u6821\u9a8c\u901a\u8fc7");
            CommonResponse commonResponse = ResponseUtil.parseResponse(response, CommonResponse.class);
            if (commonResponse == null || commonResponse.getResult() != 0) {
                CertRepository.error(callBack, 43, "phone identity error");
                return;
            }
            VerifyInfoBean bean = Params.getVerifyInfoBean();
            bean.getChipInfo().setPhone(phone);
            Request request = HttpManager.initRequest("/airIssue-api/v1/identify/authentication", JSON.toJSONString((Object)bean));
            Response identityResponse = HttpManager.getInstance().getHttpClient().newCall(request).execute();
            CommonResponse identityCommonResponse = CertRepository.checkResponse(identityResponse, callBack, 43, "identity error");
            if (identityCommonResponse == null) {
                return;
            }
            if (AirCertSdk.getsInstance().getAirCertConfig().getCardType() == 4) {
                boolean initSuccess = true;
                if (!NetVHSMHandle.isNetVHSMCanUse()) {
                    initSuccess = NetVHSMHandle.initVHSM(AirCertSdk.getsInstance().getContext(), HttpUrl.getVhsmAddress());
                }
                if (initSuccess) {
                    CryptoDevManager.getInstance().refresh();
                    DeviceWrapper.getDevInfo();
                } else {
                    CertRepository.error(callBack, 43, "vhsm init error");
                    return;
                }
            }
            String result = identityCommonResponse.getMessage();
            String p10RequestBC = PKCS10Utils.getInstance().getP10RequestBC(DeviceCache.getsInstance().getCacheCryptoDevInfo().getType(), AirCertSdk.getsInstance().getAirCertConfig().getContainerNum(), result, true);
            SdkLog.loge("p10--" + p10RequestBC);
            if (TextUtils.isEmpty((CharSequence)p10RequestBC) || p10RequestBC.startsWith("errorCode")) {
                CertRepository.error(callBack, 43, "p10 error");
                return;
            }
            CertApplyBean certApplyBean = Params.getCertApplyBean(p10RequestBC, phone);
            Request certApplyRequest = HttpManager.initRequest("/airIssue-api/v1/cert/application", JSON.toJSONString((Object)certApplyBean));
            Response certApplyResponse = HttpManager.getInstance().getHttpClient().newCall(certApplyRequest).execute();
            CommonResponse certApplyCommonResponse = ResponseUtil.parseResponse(certApplyResponse, CommonResponse.class);
            if (certApplyCommonResponse == null || TextUtils.isEmpty((CharSequence)certApplyCommonResponse.getCert())) {
                CertRepository.error(callBack, 43, "cert apply error");
                return;
            }
            int resultCode = CertRepository.writeCert(certApplyCommonResponse);
            if (resultCode != 0) {
                SdkLog.loge("write cert result" + resultCode);
                CertRepository.error(callBack, 43, "operate write cert error");
                WriteFailBean writeFailBean = Params.getWriteFailBean(certApplyCommonResponse.getCert());
                Request writeFailRequest = HttpManager.initRequest("/airIssue-api/v1/cert/write", JSON.toJSONString((Object)writeFailBean));
                HttpManager.getInstance().getHttpClient().newCall(writeFailRequest).execute();
                return;
            }
            CertDetailInfoBean certDetailInfoBean = CertHelper.readCertInfo();
            CertRepository.success(callBack, certDetailInfoBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void queryCertState(HttpCallBack<Integer> callBack) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("cardType", DeviceWrapper.convertCardType(DeviceWrapper.getCurrentDevInfo().getType().getType()));
            CertDetailInfoBean bean = CertHelper.readCertInfo();
            jsonObject.put("sn", (Object)(bean == null ? "" : bean.getSn()));
            Request requestBody = HttpManager.initRequest("/airIssue-api/v1/cert/status", jsonObject.toString());
            Response response = HttpManager.getInstance().getHttpClient().newCall(requestBody).execute();
            CommonResponse commonResponse = ResponseUtil.parseResponse(response, CommonResponse.class);
            if (commonResponse == null) {
                CertRepository.error(callBack, 404, "querycert net error");
                return;
            }
            if (commonResponse.getErrCode() != 0) {
                if (commonResponse.getErrCode() == 4261) {
                    CertHelper.deleteCert();
                    CertRepository.success(callBack, 4);
                } else {
                    CertRepository.error(callBack, 22, "cert states error");
                }
                return;
            }
            if (commonResponse.getResult() == 4) {
                CertHelper.deleteCert();
                CertRepository.success(callBack, 4);
            } else if (commonResponse.getResult() == 3) {
                if (bean == null) {
                    CertRepository.success(callBack, 21);
                } else if (CertHelper.verifyCertByRoot(DeviceCache.getsInstance().getCacheCryptoDevInfo().getType(), AirCertSdk.getsInstance().getAirCertConfig().getContainerNum())) {
                    CertRepository.success(callBack, 3);
                } else {
                    CertRepository.error(callBack, 23, "root cert no match");
                }
            } else {
                CertRepository.error(callBack, 22, "cert states error");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void revoke(HttpCallBack<Boolean> callBack) {
        try {
            RevokedCertBean bean = Params.getRevokedCertBean();
            Request requestBody = HttpManager.initRequest("/airIssue-api/v1/cert/revoke", JSON.toJSONString((Object)bean));
            Response response = HttpManager.getInstance().getHttpClient().newCall(requestBody).execute();
            CommonResponse commonResponse = ResponseUtil.parseResponse(response, CommonResponse.class);
            if (commonResponse == null) {
                CertRepository.error(callBack, 404, "revoke net error");
                return;
            }
            if (commonResponse.getResult() == 1) {
                OperateCertHelper.clearContainer(DeviceWrapper.getCurrentDevInfo().getType(), AirCertSdk.getsInstance().getAirCertConfig().getContainerNum());
                CertRepository.success(callBack, true);
                return;
            }
            CertRepository.error(callBack, 2, "revoke error");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean verifyCert() {
        CertDetailInfoBean bean = CertHelper.readCertInfo();
        if (bean == null) {
            return false;
        }
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("cardType", DeviceWrapper.convertCardType(DeviceWrapper.getCurrentDevInfo().getType().getType()));
            jsonObject.put("sn", (Object)bean.getSn());
            Request requestBody = HttpManager.initRequest("/airIssue-api/v1/cert/status", jsonObject.toString());
            Response response = HttpManager.getInstance().getHttpClient().newCall(requestBody).execute();
            CommonResponse commonResponse = ResponseUtil.parseResponse(response, CommonResponse.class);
            if (commonResponse == null || commonResponse.getResult() != 3) {
                CertHelper.deleteCert();
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            CertHelper.deleteCert();
            return false;
        }
    }

    private static int writeCert(CommonResponse certInfoBean) {
        OperateCertHelper helper = new OperateCertHelper();
        return helper.importCert(DeviceCache.getsInstance().getCacheCryptoDevInfo().getType(), AirCertSdk.getsInstance().getAirCertConfig().getContainerNum(), certInfoBean.getCert());
    }

    private static CommonResponse checkResponse(Response response, HttpCallBack<CertDetailInfoBean> callBack, int errorCode, String errorMsg) {
        CommonResponse commonResponse = ResponseUtil.parseResponse(response, CommonResponse.class);
        if (!response.isSuccessful() || commonResponse == null || !commonResponse.isSuccess()) {
            String msg = commonResponse != null && !TextUtils.isEmpty((CharSequence)commonResponse.getMessage()) ? commonResponse.getMessage() : errorMsg;
            String result = commonResponse != null ? "result:" + commonResponse.getResult() + "errorCode" + commonResponse.getErrCode() : "";
            SdkLog.loge("checkResponse----" + result + "----" + errorMsg);
            CertRepository.error(callBack, errorCode, msg);
            return null;
        }
        return commonResponse;
    }

    private static void error(final HttpCallBack callBack, final int code, final String msg) {
        if (callBack == null) {
            return;
        }
        HttpManager.getInstance().executorUi(new Runnable(){

            @Override
            public void run() {
                SdkLog.loge("error----" + code + "----" + msg);
                callBack.onError(code, msg);
            }
        });
    }

    private static <T> void success(final HttpCallBack<T> callBack, final T data) {
        if (callBack == null) {
            return;
        }
        HttpManager.getInstance().executorUi(new Runnable(){

            @Override
            public void run() {
                callBack.onSuccess(data);
            }
        });
    }
}

