/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.sdk.device;

import android.text.TextUtils;
import com.xdja.aircert.sdk.AirCertSdk;
import com.xdja.aircert.sdk.bean.CertDetailInfoBean;
import com.xdja.aircert.sdk.config.AirCertConfig;
import com.xdja.aircert.sdk.config.AirCertConstant;
import com.xdja.aircert.sdk.config.AlgType;
import com.xdja.aircert.sdk.device.DeviceCache;
import com.xdja.aircert.sdk.device.DeviceWrapper;
import com.xdja.aircert.sdk.device.OperateCertHelper;
import com.xdja.aircert.sdk.util.FidUtil;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CertHelper {
    public static String getAlgType() {
        String defaultAlgType = AlgType.getDefault();
        AirCertConfig certConfig = AirCertSdk.getsInstance().getAirCertConfig();
        if (certConfig.getAlgType() == 3) {
            return CertHelper.transAlgType("RSA");
        }
        return CertHelper.transAlgType(defaultAlgType);
    }

    private static String transAlgType(String algType) {
        return algType.equals("RSA") ? "1.0" : "2.0";
    }

    public static String getCertRule(@AirCertConstant.ALG_TYPE int algType) {
        return algType == 2 ? "\u53cc\u8bc1" : "\u5355\u8bc1";
    }

    public static int getRole(int containerNum) {
        if (String.valueOf(containerNum).equals(4) || String.valueOf(containerNum).equals(6)) {
            return 17;
        }
        return 1;
    }

    public static String getPin() {
        return "111111";
    }

    public static CertDetailInfoBean readCertInfo() {
        return OperateCertHelper.readCertFromContainer(DeviceCache.getsInstance().getCacheCryptoDevInfo().getType(), AirCertSdk.getsInstance().getAirCertConfig().getContainerNum(), AirCertSdk.getsInstance().getAirCertConfig().getCertType());
    }

    public static void deleteCert() {
        OperateCertHelper.clearContainer(DeviceWrapper.getCurrentDevInfo().getType(), AirCertSdk.getsInstance().getAirCertConfig().getContainerNum());
    }

    public static boolean verifyCertByRoot(CryptoDevType type, int containerNo) {
        try {
            Principal principalSubject;
            BouncyCastleProvider provider = new BouncyCastleProvider();
            Security.removeProvider("BC");
            Security.addProvider((Provider)provider);
            X509Certificate cert = CertHelper.getX509Certificate(CertHelper.readCertFromType(type, containerNo), provider);
            InputStream is = AirCertSdk.getsInstance().getContext().getAssets().open(AirCertSdk.getsInstance().getAirCertConfig().getRootCertName());
            X509Certificate root = CertHelper.getX509Certificate(is, provider);
            if (cert == null || root == null) {
                return false;
            }
            Principal principalIssuer = cert.getIssuerDN();
            if (!principalIssuer.equals(principalSubject = root.getSubjectDN())) {
                return false;
            }
            cert.verify(root.getPublicKey());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static X509Certificate getX509Certificate(InputStream is, BouncyCastleProvider provider) {
        if (is == null) {
            return null;
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", (Provider)provider);
            X509Certificate certificate = (X509Certificate)cf.generateCertificate(is);
            is.close();
            return certificate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static InputStream readCertFromType(CryptoDevType type, int containerNum) {
        byte[][] fid = FidUtil.getCertFid(containerNum);
        byte[] certBuf = new byte[2048];
        int[] certLen = new int[1];
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return null;
        }
        int result = -1;
        if (AirCertSdk.getsInstance().getAirCertConfig().getCertType().equals("\u7b7e\u540d\u8bc1\u4e66") || TextUtils.isEmpty((CharSequence)AirCertSdk.getsInstance().getAirCertConfig().getCertType())) {
            result = cryptoInstance.readCert(fid[0], certBuf, certLen);
        } else if (AirCertSdk.getsInstance().getAirCertConfig().getCertType().equals("\u52a0\u5bc6\u8bc1\u4e66")) {
            result = cryptoInstance.readCert(fid[1], certBuf, certLen);
        }
        cryptoInstance.close();
        if (result == 0) {
            return new ByteArrayInputStream(certBuf);
        }
        return null;
    }
}

