/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.sdk.net;

import com.xdja.aircert.sdk.AirCertSdk;
import com.xdja.aircert.sdk.bean.CertApplyBean;
import com.xdja.aircert.sdk.bean.CertDetailInfoBean;
import com.xdja.aircert.sdk.bean.RevokedCertBean;
import com.xdja.aircert.sdk.bean.VerifyInfoBean;
import com.xdja.aircert.sdk.bean.WriteFailBean;
import com.xdja.aircert.sdk.device.CertHelper;
import com.xdja.aircert.sdk.device.DeviceCache;
import com.xdja.aircert.sdk.device.DeviceWrapper;
import com.xdja.aircert.sdk.device.OperateCertHelper;
import com.xdja.aircert.sdk.util.DeviceUtil;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.initvhsm.utils.NetVhsmDeviceIdUtils;

public class Params {
    public static final String REQUEST_PARAM_ONLINE_VHSM = "1";

    public static VerifyInfoBean getVerifyInfoBean() {
        VerifyInfoBean bean = new VerifyInfoBean();
        bean.setCaAlg(CertHelper.getAlgType());
        VerifyInfoBean.IdCardInfoBean infoBean = new VerifyInfoBean.IdCardInfoBean();
        infoBean.setSex(1);
        bean.setIdCardInfo(infoBean);
        VerifyInfoBean.ChipInfoBean chipInfoBean = new VerifyInfoBean.ChipInfoBean();
        CryptoDevInfo cryptoDevInfo = DeviceCache.getsInstance().getCacheCryptoDevInfo();
        chipInfoBean.setCardType(String.valueOf(DeviceWrapper.convertCardType(cryptoDevInfo.getType().getType())));
        if (cryptoDevInfo.getType().getType() == CryptoDevType.DEV_TYPE_Soft.getType()) {
            chipInfoBean.setVhsmType(REQUEST_PARAM_ONLINE_VHSM);
            chipInfoBean.setImei(NetVhsmDeviceIdUtils.getDevId(AirCertSdk.getsInstance().getContext()));
        } else {
            chipInfoBean.setImei(DeviceUtil.getIMEI());
        }
        bean.setChipInfo(chipInfoBean);
        return bean;
    }

    public static CertApplyBean getCertApplyBean(String p10, String phone) {
        CertApplyBean bean = new CertApplyBean();
        bean.setP10(p10);
        CertApplyBean.ChipInfoBean chipInfo = new CertApplyBean.ChipInfoBean();
        chipInfo.setCardType(String.valueOf(DeviceWrapper.convertCardType(DeviceCache.getsInstance().getCacheCryptoDevInfo().getType().getType())));
        chipInfo.setImei(DeviceUtil.getIMEI());
        chipInfo.setImsi(DeviceUtil.getIMSI());
        chipInfo.setPhone(phone);
        bean.setChipInfo(chipInfo);
        CertApplyBean.MobileInfoBean mobileInfoBean = new CertApplyBean.MobileInfoBean();
        mobileInfoBean.setCommType(String.valueOf(DeviceUtil.getOperator()));
        mobileInfoBean.setTerminalBand(DeviceUtil.getBrand());
        mobileInfoBean.setTerminalType(REQUEST_PARAM_ONLINE_VHSM);
        bean.setMobileInfo(mobileInfoBean);
        bean.setIdentityNo(phone);
        return bean;
    }

    public static WriteFailBean getWriteFailBean(String cert) {
        WriteFailBean bean = new WriteFailBean();
        WriteFailBean.InfoBean infoBean = new WriteFailBean.InfoBean();
        OperateCertHelper helper = new OperateCertHelper();
        String sn = helper.getSn(DeviceCache.getsInstance().getCacheCryptoDevInfo().getType(), AirCertSdk.getsInstance().getAirCertConfig().getContainerNum(), cert);
        infoBean.setSn(sn);
        infoBean.setStatus(REQUEST_PARAM_ONLINE_VHSM);
        infoBean.setTime(System.currentTimeMillis());
        bean.setInfo(infoBean);
        String sign = helper.signData(DeviceCache.getsInstance().getCacheCryptoDevInfo().getType(), AirCertSdk.getsInstance().getAirCertConfig().getContainerNum(), infoBean.toString());
        bean.setSign(sign);
        int certType = DeviceWrapper.convertCardType(DeviceCache.getsInstance().getCacheCryptoDevInfo().getType().getType());
        bean.setCardType(String.valueOf(certType));
        return bean;
    }

    public static RevokedCertBean getRevokedCertBean() {
        CertDetailInfoBean certDetailInfoBean = CertHelper.readCertInfo();
        RevokedCertBean certBean = new RevokedCertBean();
        RevokedCertBean.InfoBean infoBean = new RevokedCertBean.InfoBean();
        infoBean.setReason("");
        infoBean.setSn(certDetailInfoBean != null ? certDetailInfoBean.getSn() : "");
        infoBean.setTime(System.currentTimeMillis());
        certBean.setInfo(infoBean);
        int certType = DeviceWrapper.convertCardType(DeviceCache.getsInstance().getCacheCryptoDevInfo().getType().getType());
        certBean.setCardType(certType);
        OperateCertHelper helper = new OperateCertHelper();
        String sign = helper.signData(DeviceCache.getsInstance().getCacheCryptoDevInfo().getType(), AirCertSdk.getsInstance().getAirCertConfig().getContainerNum(), infoBean.toString());
        certBean.setSign(sign);
        return certBean;
    }
}

