/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.initvhsm.utils;

import android.util.Pair;
import com.xdja.crypto.XDJACrypto;
import com.xdja.initvhsm.utils.PaddingUtils;
import java.util.Arrays;

public class EncDecData {
    public static Pair<Integer, byte[]> encData(byte[] key, byte[] source) {
        if (source == null) {
            return Pair.create((Object)0, null);
        }
        byte[] dataIn = PaddingUtils.padding(source, key.length);
        byte[] dataOut = new byte[dataIn.length];
        byte[] iv = Arrays.copyOf(key, key.length);
        int ret = XDJACrypto.getInstance().SM4New(key, 17, dataIn, dataIn.length, dataOut, iv);
        if (ret != 0) {
            return Pair.create((Object)ret, null);
        }
        return Pair.create((Object)0, (Object)dataOut);
    }

    public static Pair<Integer, byte[]> decData(byte[] key, byte[] source) {
        if (source == null) {
            return Pair.create((Object)0, null);
        }
        byte[] dataOut = new byte[source.length];
        byte[] iv = Arrays.copyOf(key, key.length);
        int ret = XDJACrypto.getInstance().SM4New(key, 16, source, source.length, dataOut, iv);
        if (ret != 0) {
            return Pair.create((Object)ret, null);
        }
        Pair<Integer, byte[]> pair = PaddingUtils.unpadding(dataOut, key.length);
        if ((Integer)pair.first != 0) {
            return Pair.create((Object)pair.first, null);
        }
        return Pair.create((Object)0, (Object)pair.second);
    }
}

