/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.sdk.cert;

import android.text.TextUtils;
import com.xdja.aircert.sdk.AirCertSdk;
import com.xdja.aircert.sdk.cert.PKCS10Utils;
import com.xdja.aircert.sdk.device.CertHelper;
import com.xdja.aircert.sdk.device.DeviceWrapper;
import com.xdja.aircert.sdk.util.FidUtil;
import com.xdja.aircert.sdk.util.SdkLog;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.cryptodev.devapi.RSAPubkey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Base64;

public class PKCS10ForRSAUtils
extends PKCS10Utils {
    public static PKCS10ForRSAUtils pkcs10ForRSAUtils = new PKCS10ForRSAUtils();

    public static PKCS10ForRSAUtils getInstance() {
        if (pkcs10ForRSAUtils == null) {
            pkcs10ForRSAUtils = new PKCS10ForRSAUtils();
        }
        return pkcs10ForRSAUtils;
    }

    @Override
    public String getP10RequestBC(CryptoDevType type, int containerNum, String dn, boolean isApplyCert) {
        int keyResult;
        if (TextUtils.isEmpty((CharSequence)dn)) {
            return "";
        }
        if (isApplyCert && (keyResult = this.generateRSAKeys(type, containerNum)) != 0 && keyResult != -1) {
            return "errorCode" + CryptoDevManager.getInstance().getErrorText(keyResult);
        }
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return "";
        }
        byte[][] keyPair = FidUtil.getKeyPairFid(type, containerNum);
        byte[] pubFid = keyPair[0];
        byte[] priFid = keyPair[1];
        RSAPubkey pubkey = new RSAPubkey();
        int result = cryptoInstance.readRSAPubKey(pubFid, pubkey);
        if (result != 0) {
            return CryptoDevManager.getInstance().getErrorText(result);
        }
        try {
            PublicKey key;
            String m = Base64.toBase64String((byte[])pubkey.getM());
            byte[] publicKeyByte = Base64.decode((String)m);
            BigInteger bigIntModulus = BigIntegers.fromUnsignedByteArray((byte[])publicKeyByte);
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(bigIntModulus, BigInteger.valueOf(pubkey.getE()));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            ASN1ObjectIdentifier rsaOID = new ASN1ObjectIdentifier("1.2.840.113549.1.1.1");
            SubjectPublicKeyInfo spi = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            X500Name x500Name = new X500Name(dn);
            CertificationRequestInfo cf1 = new CertificationRequestInfo(x500Name, spi, null);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            DEROutputStream derOutStream = new DEROutputStream((OutputStream)outStream);
            try {
                derOutStream.writeObject((ASN1Encodable)cf1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            byte[] certInfoBytes = outStream.toByteArray();
            byte[] signData = new byte[256];
            int[] signDataLen = new int[1];
            int encodeRequestInfo = cryptoInstance.RSASign(2048, priFid, 1, certInfoBytes, certInfoBytes.length, signData, signDataLen);
            if (encodeRequestInfo != 0) {
                return null;
            }
            DERBitString dbs = new DERBitString(signData);
            String signAlg = "SHA1WITHRSA";
            AlgorithmIdentifier signIdentifier = new DefaultSignatureAlgorithmIdentifierFinder().find(signAlg);
            CertificationRequest cr = new CertificationRequest(cf1, signIdentifier, dbs);
            PKCS10CertificationRequest request = new PKCS10CertificationRequest(cr);
            byte[] buffer = request.getEncoded();
            String p10 = new String(Base64.encode((byte[])buffer));
            SdkLog.loge("RSA_P10\u8bf7\u6c42\u5b57\u7b26\u4e32 \uff1a " + p10);
            if (!TextUtils.isEmpty((CharSequence)p10) && (key = PKCS10ForRSAUtils.getPublicKeyFromP10(p10)) != null) {
                byte[] pub = key.getEncoded();
                String pubKey = new String(Base64.encode((byte[])pub));
                SdkLog.loge("RSA\u516c\u94a5:" + pubKey);
            }
            return p10;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static PublicKey getPublicKeyFromP10(String p10) throws Exception {
        String P10_HEAD = "-----BEGIN CERTIFICATE REQUEST-----";
        String P10_TAIL = "-----END CERTIFICATE REQUEST-----";
        p10 = p10.replace("-----END CERTIFICATE REQUEST-----", "").replace("-----BEGIN CERTIFICATE REQUEST-----", "");
        p10 = p10.replace("\r", "").replace("\n", "");
        p10 = p10.replace("\\r", "").replace("\\n", "");
        PKCS10CertificationRequest re = new PKCS10CertificationRequest(Base64.decode((String)p10));
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        PublicKey publicKey = converter.getPublicKey(re.getSubjectPublicKeyInfo());
        return publicKey;
    }

    private int generateRSAKeys(CryptoDevType type, int containerNum) {
        int genRsaKeysPairResult = -1;
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return genRsaKeysPairResult;
        }
        int pinResult = DeviceWrapper.verifyPin(type, containerNum, "");
        if (pinResult != 0) {
            return pinResult;
        }
        genRsaKeysPairResult = this.genRSAKeyPair(cryptoInstance, type, containerNum);
        if (genRsaKeysPairResult == 2030 || genRsaKeysPairResult == 2041) {
            if (cryptoInstance.createContainer(CertHelper.getRole(containerNum), CertHelper.getPin(), containerNum, "") == 0) {
                genRsaKeysPairResult = this.genRSAKeyPair(cryptoInstance, type, containerNum);
            } else {
                return genRsaKeysPairResult;
            }
        }
        cryptoInstance.close();
        return genRsaKeysPairResult;
    }

    private int genRSAKeyPair(CryptoInstance cryptoInstance, CryptoDevType type, int containerNum) {
        int genRsaKeysPairResult = -1;
        genRsaKeysPairResult = CertHelper.getCertRule(AirCertSdk.getsInstance().getAirCertConfig().getAlgType()).equals("\u5355\u8bc1") ? (TextUtils.isEmpty((CharSequence)AirCertSdk.getsInstance().getAirCertConfig().getCertType()) || AirCertSdk.getsInstance().getAirCertConfig().getCertType().equals("\u7b7e\u540d\u8bc1\u4e66") ? cryptoInstance.genSignRSAKeyPair(containerNum, 2048) : cryptoInstance.genExchangeRSAKeyPair(containerNum, 2048)) : cryptoInstance.genSignRSAKeyPair(containerNum, 2048);
        return genRsaKeysPairResult;
    }
}

