/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.sdk.device;

import android.content.Context;
import android.os.Environment;
import android.util.Log;
import com.xdja.aircert.sdk.util.SdkLog;
import com.xdja.initvhsm.net.NetRespository;
import com.xdja.initvhsm.utils.NetVhsmDeviceIdUtils;
import com.xdja.vhsm.base.VHSMBase;
import com.xdja.vhsm.base.VHSM_INIT_PARAM;
import com.xdja.vhsm.base.VHSM_SERVER_INFO;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class NetVHSMHandle {
    private static final String FILE_DIR = "xdja/vhsm/net/";
    private static final String RAND_FILE_PATH = "xdja/vhsm/net/rand.bin";
    private static final String KDAT_FILE_PATH = "xdja/vhsm/net/vhsm.dat";
    private static final String WBOX_FILE_PATH = "xdja/vhsm/net/wbox.lib";
    private static final String VHSM_LIB_FILE_PATH = "xdja/vhsm/net/vhsm.lib";

    public static String getNetVhsmCardId(Context context) {
        byte[] buf = new byte[1024];
        int[] len = new int[1];
        VHSMBase vhsmBase = new VHSMBase();
        vhsmBase.GetSerialNumber(buf, len);
        vhsmBase.GetCardIdBySerialNumber(buf, len[0], buf, len);
        String netVhsmCardId = new String(Arrays.copyOf(buf, len[0]));
        return netVhsmCardId;
    }

    public static boolean initVHSM(Context context, String ipPort) {
        String[] address = ipPort.split(":");
        if (address.length != 2) {
            throw new IllegalArgumentException("vhsmipport error");
        }
        NetRespository netRespository = NetRespository.create(context, address[0], Integer.parseInt(address[1]));
        int initResult = netRespository.init(NetVhsmDeviceIdUtils.getDevId(context));
        SdkLog.loge("37 NetVHSMHandle run :initResult =  " + initResult);
        if (initResult == 0) {
            SdkLog.logi("VHSM\u521d\u59cb\u5316\u6210\u529f");
            int initFile = NetRespository.initVhsmlibFile(context, address[0], Integer.parseInt(address[1]));
            return initFile == 0;
        }
        SdkLog.loge("VHSM\u521d\u59cb\u5316\u5931\u8d25");
        return false;
    }

    public static boolean initVHSM(Context context, String ipPort, String phoneStr, byte[] sig) {
        String[] address = ipPort.split(":");
        int ret = 0;
        Log.e((String)"jff", (String)"84 NetVHSMHandle initVHSM : ");
        VHSM_SERVER_INFO serverInfo = new VHSM_SERVER_INFO();
        VHSMBase vhsm = new VHSMBase();
        byte[] buf = new byte[1024];
        int[] len = new int[1];
        vhsm.GetVersion(buf, len);
        vhsm.GetDateTime(buf, len);
        ret = vhsm.InitVHSM(30, null);
        Log.e((String)"jff", (String)("96 NetVHSMHandle initVHSM ret : " + ret));
        if (ret != 0) {
            Log.e((String)"jff", (String)"100 NetVHSMHandle initVHSM : ");
            serverInfo.addrType = 1;
            System.arraycopy(address[0].getBytes(StandardCharsets.UTF_8), 0, serverInfo.ip, 0, address[0].length());
            serverInfo.port = Integer.parseInt(address[1]);
            serverInfo.serverType = 3;
            ret = vhsm.SetServerInfo(serverInfo);
            Log.e((String)"jff", (String)("107 NetVHSMHandle initVHSM ret: " + ret));
            if (ret != 0) {
                Log.e((String)"jff", (String)"110 NetVHSMHandle initVHSM : ");
                return false;
            }
            byte[] nameB = new byte[]{};
            String name = "";
            if (name != null && name.length() > 0) {
                nameB = name.getBytes(StandardCharsets.UTF_8);
            }
            byte[] phone = phoneStr.getBytes(StandardCharsets.UTF_8);
            String deptStr = "\u6682\u65e0";
            byte[] deptB = deptStr.getBytes(StandardCharsets.UTF_8);
            byte[] signature = sig;
            Log.e((String)"jff", (String)"123 NetVHSMHandle initVHSM : ");
            VHSM_INIT_PARAM param = new VHSM_INIT_PARAM();
            System.arraycopy(nameB, 0, param.name, 0, nameB.length);
            System.arraycopy(phone, 0, param.phone, 0, phone.length);
            System.arraycopy(deptB, 0, param.dept, 0, deptB.length);
            System.arraycopy(signature, 0, param.signature, 0, signature.length);
            param.initType = 2;
            ret = vhsm.InitVHSM(11, param);
            Log.e((String)"jff", (String)("128 NetVHSMHandle initVHSM ret : " + ret));
            ret = vhsm.InitVHSM(1, param);
            System.out.println("VHSM_InitVHSM\uff08VHSM_OP_QUERY\uff09 return " + ret);
            if (ret != 0) {
                return false;
            }
        }
        return true;
    }

    public static boolean isNetVHSMCanUse() {
        File storageDir = Environment.getExternalStorageDirectory();
        File randFile = new File(storageDir, RAND_FILE_PATH);
        if (!randFile.exists()) {
            return false;
        }
        File wboxFile = new File(storageDir, WBOX_FILE_PATH);
        if (!wboxFile.exists()) {
            return false;
        }
        File kdatFile = new File(storageDir, KDAT_FILE_PATH);
        if (!kdatFile.exists()) {
            return false;
        }
        File vhsmLibFile = new File(storageDir, VHSM_LIB_FILE_PATH);
        return vhsmLibFile.exists();
    }
}

