/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.sdk.net;

import android.text.TextUtils;
import com.xdja.aircert.sdk.AirCertSdk;
import com.xdja.aircert.sdk.util.SdkLog;
import java.net.InetSocketAddress;
import java.net.Socket;

public class HttpUrl {
    public static final String APPLY = "/airIssue-api/v1/cert/application";
    public static final String CERT_STATUS = "/airIssue-api/v1/cert/status";
    public static final String IDENTITY_PHONE = "/airIssue-api/v1/identity/phone";
    public static final String IDENTITY_AUTH = "/airIssue-api/v1/identify/authentication";
    public static final String WRITE_STATUS = "/airIssue-api/v1/cert/write";
    public static final String REVOKE = "/airIssue-api/v1/cert/revoke";
    private static String connectedBaseUrl;
    private static String baseVhsmUrl;

    static String getUrl(String url) {
        String baseUrl;
        String tail;
        if (TextUtils.isEmpty((CharSequence)connectedBaseUrl)) {
            connectedBaseUrl = HttpUrl.telnetAddress(AirCertSdk.getsInstance().getAirCertConfig().getServerAddress());
        }
        if ("/".equals(tail = String.valueOf((baseUrl = "https://" + connectedBaseUrl).charAt(baseUrl.length() - 1)))) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        SdkLog.loge("server url" + baseUrl);
        return baseUrl + url;
    }

    public static String getVhsmAddress() {
        if (TextUtils.isEmpty((CharSequence)baseVhsmUrl)) {
            baseVhsmUrl = HttpUrl.telnetAddress(AirCertSdk.getsInstance().getAirCertConfig().getVhsmIpPort());
            SdkLog.loge("vhsm url" + baseVhsmUrl);
            return baseVhsmUrl;
        }
        SdkLog.loge("vhsm url" + baseVhsmUrl);
        return baseVhsmUrl;
    }

    static void useTelnet() {
        connectedBaseUrl = "";
        baseVhsmUrl = "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String telnetAddress(String address) {
        String[] addresses;
        if (!address.contains("|")) return address;
        String[] stringArray = addresses = address.split("\\|");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String url = stringArray[n2];
            try (Socket socket = new Socket();){
                String[] ipPort = url.split(":");
                socket.connect(new InetSocketAddress(ipPort[0], Integer.parseInt(ipPort[1])), 3000);
                String string = url;
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
                ++n2;
            }
        }
        return addresses[0];
    }
}

