/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.aircert.sdk.util;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.xdja.aircert.sdk.AirCertSdk;

public class DeviceUtil {
    public static String getIMSI() {
        Context context = AirCertSdk.getsInstance().getContext();
        TelephonyManager mTelephonyMgr = (TelephonyManager)context.getSystemService("phone");
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            return "";
        }
        String imsi = mTelephonyMgr.getSubscriberId();
        return TextUtils.isEmpty((CharSequence)imsi) ? "" : imsi;
    }

    public static String getIMEI() {
        Context context = AirCertSdk.getsInstance().getContext();
        String imei = "";
        imei = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return imei;
    }

    public static int getOperator() {
        String imsi = DeviceUtil.getIMSI();
        if (TextUtils.isEmpty((CharSequence)imsi)) {
            return -1;
        }
        return DeviceUtil.getOperatorFromIMSI(imsi);
    }

    public static String getBrand() {
        return Build.BRAND;
    }

    private static int getOperatorFromIMSI(String imsi) {
        if (imsi.startsWith("46000") || imsi.startsWith("46002") || imsi.equals("46007")) {
            return 1;
        }
        if (imsi.startsWith("46001") || imsi.startsWith("46006")) {
            return 2;
        }
        if (imsi.startsWith("46003") || imsi.startsWith("46005")) {
            return 3;
        }
        return 0;
    }

    public static byte[] hexStr2byteArr(String hex) {
        if (hex.length() % 2 != 0) {
            hex = "0" + hex;
        }
        int len = hex.length() / 2;
        byte[] result = new byte[len];
        char[] achar = hex.toCharArray();
        for (int i = 0; i < len; ++i) {
            String item = new String(achar, i * 2, 2);
            result[i] = (byte)Integer.parseInt(item, 16);
        }
        return result;
    }
}

