/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.example;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.baidu.idl.face.example.Config;
import com.baidu.idl.face.example.ExampleApplication;
import com.baidu.idl.face.example.FaceDetectExpActivity;
import com.baidu.idl.face.example.FaceLivenessExpActivity;
import com.baidu.idl.face.example.SettingsActivity;
import com.baidu.idl.face.platform.FaceConfig;
import com.baidu.idl.face.platform.FaceSDKManager;
import com.baidu.idl.face.platform.LivenessTypeEnum;
import com.xdja.aircert2.R;

public class MainActivity
extends Activity {
    private static final String TAG = MainActivity.class.getSimpleName();
    private RecyclerView.LayoutManager mLayoutManager;
    private RecyclerView mRecyclerView;
    private RecyclerCustomAdapter mCustomAdapter;
    private Dialog mDefaultDialog;
    private int[] mDataset = new int[]{R.string.main_item_face_live, R.string.main_item_face_detect};

    private void randomAdd() {
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.baiduface_main);
        ExampleApplication.livenessList.clear();
        ExampleApplication.livenessList.add(LivenessTypeEnum.Eye);
        ExampleApplication.livenessList.add(LivenessTypeEnum.Mouth);
        ExampleApplication.livenessList.add(LivenessTypeEnum.HeadUp);
        ExampleApplication.livenessList.add(LivenessTypeEnum.HeadDown);
        this.mLayoutManager = new LinearLayoutManager((Context)this);
        this.mCustomAdapter = new RecyclerCustomAdapter(this.mDataset);
        this.findViewById(R.id.baidu_settings).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MainActivity.this.startItemActivity(SettingsActivity.class);
            }
        });
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.main_recycler_view);
        int scrollPosition = 0;
        if (this.mRecyclerView.getLayoutManager() != null) {
            scrollPosition = ((LinearLayoutManager)this.mRecyclerView.getLayoutManager()).findFirstCompletelyVisibleItemPosition();
        }
        this.mLayoutManager = new LinearLayoutManager((Context)this);
        this.mRecyclerView.setLayoutManager(this.mLayoutManager);
        this.mRecyclerView.scrollToPosition(scrollPosition);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mCustomAdapter);
        this.requestPermissions(99, "android.permission.CAMERA");
        this.initLib();
    }

    private void initLib() {
        FaceSDKManager.getInstance().initialize((Context)this, Config.licenseID, Config.licenseFileName);
    }

    private void setFaceConfig() {
        FaceConfig config = FaceSDKManager.getInstance().getFaceConfig();
        config.setLivenessTypeList(ExampleApplication.livenessList);
        config.setLivenessRandom(ExampleApplication.isLivenessRandom);
        config.setBlurnessValue(0.5f);
        config.setBrightnessValue(40.0f);
        config.setCropFaceValue(400);
        config.setHeadPitchValue(10);
        config.setHeadRollValue(10);
        config.setHeadYawValue(10);
        config.setMinFaceSize(200);
        config.setNotFaceValue(0.6f);
        config.setOcclusionValue(0.5f);
        config.setCheckFaceQuality(true);
        config.setFaceDecodeNumberOfThreads(2);
        FaceSDKManager.getInstance().setFaceConfig(config);
    }

    private void startItemActivity(Class itemClass) {
        this.setFaceConfig();
        this.startActivity(new Intent((Context)this, itemClass));
        this.finish();
    }

    public void requestPermissions(int requestCode, String permission2) {
        if (permission2 != null && permission2.length() > 0) {
            try {
                int hasPer;
                if (Build.VERSION.SDK_INT >= 23 && (hasPer = this.checkSelfPermission(permission2)) != 0) {
                    boolean isShould = this.shouldShowRequestPermissionRationale(permission2);
                    this.requestPermissions(new String[]{permission2}, requestCode);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @TargetApi(value=23)
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        boolean flag = false;
        for (int i = 0; i < permissions.length; ++i) {
            if (0 != grantResults[i]) continue;
            flag = true;
        }
        if (!flag) {
            this.requestPermissions(99, "android.permission.CAMERA");
        }
    }

    protected void showMessageDialog(String title, String message) {
        if (this.mDefaultDialog == null) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setTitle((CharSequence)title).setMessage((CharSequence)message).setNegativeButton((CharSequence)"ok", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    MainActivity.this.mDefaultDialog.dismiss();
                    MainActivity.this.finish();
                }
            });
            this.mDefaultDialog = builder.create();
            this.mDefaultDialog.setCancelable(true);
        }
        this.mDefaultDialog.dismiss();
        this.mDefaultDialog.show();
    }

    class RecyclerCustomAdapter
    extends RecyclerView.Adapter<ViewHolder> {
        final int[] itemDataSet;

        public RecyclerCustomAdapter(int[] dataSet) {
            this.itemDataSet = dataSet;
        }

        public ViewHolder onCreateViewHolder(ViewGroup viewGroup, int viewType) {
            View v = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.item_main, viewGroup, false);
            return new ViewHolder(v);
        }

        public void onBindViewHolder(ViewHolder viewHolder, final int position) {
            viewHolder.tv.setText(this.itemDataSet[position]);
            viewHolder.tv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (RecyclerCustomAdapter.this.itemDataSet[position] == R.string.main_item_face_live) {
                        MainActivity.this.startItemActivity(FaceLivenessExpActivity.class);
                    } else if (RecyclerCustomAdapter.this.itemDataSet[position] == R.string.main_item_face_detect) {
                        MainActivity.this.startItemActivity(FaceDetectExpActivity.class);
                    }
                }
            });
        }

        public int getItemCount() {
            return this.itemDataSet.length;
        }

        class ViewHolder
        extends RecyclerView.ViewHolder {
            public final View rv;
            public final TextView tv;

            public ViewHolder(View v) {
                super(v);
                this.rv = v;
                this.tv = (TextView)v.findViewById(R.id.item_main_text);
            }
        }
    }
}

