/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.example;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import com.baidu.idl.face.example.ExampleApplication;
import com.baidu.idl.face.example.widget.DefaultDialog;
import com.baidu.idl.face.platform.FaceConfig;
import com.baidu.idl.face.platform.FaceSDKManager;
import com.baidu.idl.face.platform.FaceStatusNewEnum;
import com.baidu.idl.face.platform.LivenessTypeEnum;
import com.baidu.idl.face.platform.model.ImageInfo;
import com.baidu.idl.face.platform.ui.FaceLivenessActivity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class FaceLivenessExpActivity
extends FaceLivenessActivity {
    private DefaultDialog mDefaultDialog;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init();
    }

    private void init() {
        this.initMovement();
        this.setFaceConfig();
    }

    private void initMovement() {
        this.randomAdd();
    }

    private void randomAdd() {
        ExampleApplication.livenessList.clear();
        ArrayList<LivenessTypeEnum> list = new ArrayList<LivenessTypeEnum>();
        list.add(LivenessTypeEnum.Mouth);
        list.add(LivenessTypeEnum.HeadUp);
        list.add(LivenessTypeEnum.HeadDown);
        list.add(LivenessTypeEnum.HeadLeft);
        list.add(LivenessTypeEnum.HeadRight);
        list.add(LivenessTypeEnum.HeadLeftOrRight);
        Collections.shuffle(list);
        ExampleApplication.livenessList.addAll(list.subList(0, 3));
    }

    private void setFaceConfig() {
        FaceConfig config = FaceSDKManager.getInstance().getFaceConfig();
        config.setMinFaceSize(200);
        config.setNotFaceValue(0.6f);
        config.setBlurnessValue(0.3f);
        config.setBrightnessValue(82.0f);
        config.setOcclusionValue(0.5f);
        config.setHeadPitchValue(8);
        config.setHeadYawValue(8);
        config.setEyeClosedValue(0.7f);
        config.setCacheImageNum(3);
        config.setOpenMask(true);
        config.setMaskValue(0.7f);
        config.setLivenessTypeList(ExampleApplication.livenessList);
        config.setLivenessRandom(ExampleApplication.isLivenessRandom);
        config.setSound(false);
        config.setScale(1.0f);
        config.setCropHeight(640);
        config.setEnlargeRatio(1.5f);
        config.setSecType(0);
        FaceSDKManager.getInstance().setFaceConfig(config);
    }

    public void onLivenessCompletion(FaceStatusNewEnum status, String message, HashMap<String, ImageInfo> base64ImageCropMap, HashMap<String, ImageInfo> base64ImageSrcMap, int currentLivenessCount) {
        super.onLivenessCompletion(status, message, base64ImageCropMap, base64ImageSrcMap, currentLivenessCount);
        if (!(status == FaceStatusNewEnum.OK && this.mIsCompletion || status != FaceStatusNewEnum.DetectRemindCodeTimeout)) {
            this.showMessageDialog("\u6d3b\u4f53\u68c0\u6d4b", "\u91c7\u96c6\u8d85\u65f6");
        }
    }

    private void showMessageDialog(String title, String message) {
        if (this.mDefaultDialog == null) {
            DefaultDialog.Builder builder = new DefaultDialog.Builder((Context)this);
            builder.setTitle(title).setMessage(message).setNegativeButton("\u786e\u8ba4", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    FaceLivenessExpActivity.this.mDefaultDialog.dismiss();
                    FaceLivenessExpActivity.this.finish();
                }
            });
            this.mDefaultDialog = builder.create();
            this.mDefaultDialog.setCancelable(true);
        }
        this.mDefaultDialog.dismiss();
        this.mDefaultDialog.show();
    }

    public void finish() {
        super.finish();
    }
}

