/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.example;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import com.baidu.idl.face.example.Config;
import com.baidu.idl.face.example.ExampleApplication;
import com.baidu.idl.face.example.widget.DefaultDialog;
import com.baidu.idl.face.platform.FaceConfig;
import com.baidu.idl.face.platform.FaceSDKManager;
import com.baidu.idl.face.platform.FaceStatusEnum;
import com.baidu.idl.face.platform.LivenessTypeEnum;
import com.baidu.idl.face.platform.ui.FaceLivenessActivity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class FaceLivenessExpActivity
extends FaceLivenessActivity {
    private DefaultDialog mDefaultDialog;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init();
    }

    private void init() {
        this.initMovement();
        this.initLib();
        this.setFaceConfig();
    }

    private void initMovement() {
        this.randomAdd();
    }

    private void randomAdd() {
        ExampleApplication.livenessList.clear();
        ArrayList<LivenessTypeEnum> list = new ArrayList<LivenessTypeEnum>();
        list.add(LivenessTypeEnum.Eye);
        list.add(LivenessTypeEnum.Mouth);
        list.add(LivenessTypeEnum.HeadUp);
        list.add(LivenessTypeEnum.HeadDown);
        list.add(LivenessTypeEnum.HeadLeft);
        list.add(LivenessTypeEnum.HeadRight);
        list.add(LivenessTypeEnum.HeadLeftOrRight);
        Collections.shuffle(list);
        ExampleApplication.livenessList.addAll(list.subList(0, 3));
    }

    private void initLib() {
        FaceSDKManager.getInstance().initialize((Context)this, Config.licenseID, Config.licenseFileName);
    }

    private void setFaceConfig() {
        FaceConfig config = FaceSDKManager.getInstance().getFaceConfig();
        config.setLivenessTypeList(ExampleApplication.livenessList);
        config.setLivenessRandom(ExampleApplication.isLivenessRandom);
        config.setBlurnessValue(0.5f);
        config.setBrightnessValue(40.0f);
        config.setCropFaceValue(400);
        config.setHeadPitchValue(10);
        config.setHeadRollValue(10);
        config.setHeadYawValue(10);
        config.setMinFaceSize(200);
        config.setNotFaceValue(0.6f);
        config.setOcclusionValue(0.5f);
        config.setCheckFaceQuality(true);
        config.setFaceDecodeNumberOfThreads(2);
        FaceSDKManager.getInstance().setFaceConfig(config);
    }

    public void onLivenessCompletion(FaceStatusEnum status, String message, HashMap<String, String> base64ImageMap) {
        super.onLivenessCompletion(status, message, base64ImageMap);
        if (!(status == FaceStatusEnum.OK && this.mIsCompletion || status != FaceStatusEnum.Error_DetectTimeout && status != FaceStatusEnum.Error_LivenessTimeout && status != FaceStatusEnum.Error_Timeout)) {
            this.showMessageDialog("\u6d3b\u4f53\u68c0\u6d4b", "\u91c7\u96c6\u8d85\u65f6");
        }
    }

    private void showMessageDialog(String title, String message) {
        if (this.mDefaultDialog == null) {
            DefaultDialog.Builder builder = new DefaultDialog.Builder((Context)this);
            builder.setTitle(title).setMessage(message).setNegativeButton("\u786e\u8ba4", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    FaceLivenessExpActivity.this.mDefaultDialog.dismiss();
                    FaceLivenessExpActivity.this.finish();
                }
            });
            this.mDefaultDialog = builder.create();
            this.mDefaultDialog.setCancelable(true);
        }
        this.mDefaultDialog.dismiss();
        this.mDefaultDialog.show();
    }

    public void finish() {
        super.finish();
    }
}

