/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.fp;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.baidu.aip.fp.APIService;
import com.baidu.aip.fp.BaseActivity;
import com.baidu.aip.fp.FaceDetectExpActivity;
import com.baidu.aip.fp.OnResultListener;
import com.baidu.aip.fp.exception.FaceException;
import com.baidu.aip.fp.model.ResponseResult;
import com.baidu.aip.fp.utils.BitmapUtil;
import com.baidu.aip.fp.utils.ImageSaveUtil;
import com.xdja.aircert1.R;
import java.io.File;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class CompareActivity
extends BaseActivity
implements View.OnClickListener {
    public static final String REGISTER_NAME = "EXTRA_REG_NAME";
    private static final int PHOTO_REQUEST_GALLERY = 0;
    private static final int REQUEST_TRACK_FACE = 1;
    private Bitmap mFirstBitmap;
    private Bitmap mSecondBitmap;
    private ImageView mImageView1;
    private ImageView mImageView2;
    private Button mCompareBtn;
    private Button mSelBtn;
    private Button mCollectBtn;
    private TextView mScoreTv;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_compare);
        this.initView();
    }

    private void initView() {
        this.mImageView1 = (ImageView)this.findViewById(R.id.imageIv1);
        this.mImageView2 = (ImageView)this.findViewById(R.id.imageIv2);
        this.mFirstBitmap = BitmapUtil.getBitmap("ic_first.jpg", (Context)this);
        if (this.mFirstBitmap != null) {
            this.mImageView1.setImageBitmap(this.mFirstBitmap);
        }
        this.mSecondBitmap = BitmapUtil.getBitmap("ic_second.jpg", (Context)this);
        if (this.mSecondBitmap != null) {
            this.mImageView2.setImageBitmap(this.mSecondBitmap);
        }
        this.mCompareBtn = (Button)this.findViewById(R.id.compareBtn);
        this.mCompareBtn.setOnClickListener((View.OnClickListener)this);
        this.mScoreTv = (TextView)this.findViewById(R.id.scoreTv);
        this.mScoreTv.setVisibility(8);
        this.mSelBtn = (Button)this.findViewById(R.id.selBtn);
        this.mCollectBtn = (Button)this.findViewById(R.id.collectBtn);
        this.mSelBtn.setOnClickListener((View.OnClickListener)this);
        this.mCollectBtn.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.compareBtn) {
            this.faceCompare(this.mFirstBitmap, this.mSecondBitmap);
        } else if (i == R.id.selBtn) {
            this.chooseFromGallery();
        } else if (i == R.id.collectBtn) {
            this.trackFace();
        }
    }

    private void trackFace() {
        Intent itTrack = new Intent((Context)this, FaceDetectExpActivity.class);
        this.startActivityForResult(itTrack, 1);
    }

    private void faceCompare(Bitmap bitmap1, Bitmap bitmap2) {
        File file1 = new File(this.getFilesDir(), UUID.randomUUID().toString() + "c1.jpg");
        BitmapUtil.saveBitmap(file1.getAbsolutePath(), bitmap1);
        File file2 = new File(this.getFilesDir(), UUID.randomUUID().toString() + "c2.jpg");
        BitmapUtil.saveBitmap(file2.getAbsolutePath(), bitmap2);
        APIService.getInstance().faceCompare(new OnResultListener<ResponseResult>(){

            @Override
            public void onResult(ResponseResult result) {
                if (result != null) {
                    boolean isSame = CompareActivity.this.parseResult(result.getJsonRes());
                    Log.d((String)"CompareActivity", (String)result.getJsonRes());
                } else {
                    CompareActivity.this.mScoreTv.setVisibility(8);
                }
            }

            @Override
            public void onError(FaceException error) {
                CompareActivity.this.mScoreTv.setVisibility(8);
                if (error != null && !TextUtils.isEmpty((CharSequence)error.getErrorMessage())) {
                    Toast.makeText((Context)CompareActivity.this, (CharSequence)error.getErrorMessage(), (int)0).show();
                } else {
                    Toast.makeText((Context)CompareActivity.this, (CharSequence)"\u4eba\u8138\u6bd4\u5bf9\u5931\u8d25", (int)0).show();
                }
            }
        }, file1, file2);
    }

    private boolean parseResult(String result) {
        boolean isSame = false;
        if (TextUtils.isEmpty((CharSequence)result)) {
            this.mScoreTv.setVisibility(8);
            return isSame;
        }
        JSONObject obj = null;
        try {
            obj = new JSONObject(result);
            JSONObject resObj = obj.optJSONObject("result");
            if (resObj != null) {
                double score = resObj.getDouble("score");
                String str = this.getDecimalString(score);
                this.mScoreTv.setVisibility(0);
                this.mScoreTv.setText((CharSequence)("\u76f8\u4f3c\u5ea6\u5206\u503c:" + str));
                Log.d((String)"CompareActivity", (String)("score is:" + score));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return isSame;
    }

    private String getDecimalString(double f) {
        int n = String.valueOf(f).indexOf(46);
        String s = String.valueOf(f);
        if (f > 0.0) {
            if (n > 0 && n < s.length() - 2) {
                s = s.substring(0, n + 2);
            }
        } else if (f < 0.0 && n > 0 && n < s.length() - 3) {
            s = s.substring(0, n + 3);
        }
        return s;
    }

    private void chooseFromGallery() {
        Intent intent = new Intent("android.intent.action.PICK");
        intent.setType("image/*");
        this.startActivityForResult(intent, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 0) {
            if (data != null) {
                Cursor cursor = null;
                boolean isException = false;
                Uri selectedImage = null;
                try {
                    selectedImage = data.getData();
                    String[] filePathColumn = new String[]{"_data"};
                    cursor = this.getContentResolver().query(selectedImage, filePathColumn, null, null, null);
                    cursor.moveToFirst();
                    Bitmap cropBmp = BitmapUtil.getFromGallery((Context)this, selectedImage);
                    Bitmap zoomBmp = BitmapUtil.loadZoomBitmap((Context)this, cropBmp);
                    if (zoomBmp != null) {
                        this.mImageView1.setVisibility(0);
                        this.mImageView1.setImageBitmap(zoomBmp);
                        this.mFirstBitmap = zoomBmp;
                    } else {
                        Toast.makeText((Context)this, (CharSequence)"\u56fe\u7247\u9009\u62e9\u5931\u8d25", (int)0).show();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    isException = true;
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                if (isException) {
                    Toast.makeText((Context)this, (CharSequence)"\u56fe\u7247\u9009\u62e9\u5931\u8d25", (int)0).show();
                }
            }
        } else if (requestCode == 1) {
            if (resultCode == -1) {
                Bitmap bmp = ImageSaveUtil.loadCameraBitmap((Context)this, "best_head.jpg");
                this.mImageView2.setVisibility(0);
                this.mImageView2.setImageBitmap(bmp);
                this.mSecondBitmap = bmp;
            } else {
                Toast.makeText((Context)this, (CharSequence)"\u91c7\u96c6\u56fe\u7247\u5931\u8d25", (int)0).show();
            }
        }
        super.onActivityResult(requestCode, resultCode, data);
    }
}

