/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.fp;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import com.baidu.aip.fp.FaceOnlineVerifyActivity;
import com.baidu.aip.fp.utils.FileUtil;
import com.baidu.ocr.sdk.OCR;
import com.baidu.ocr.sdk.OnResultListener;
import com.baidu.ocr.sdk.exception.OCRError;
import com.baidu.ocr.sdk.model.AccessToken;
import com.baidu.ocr.sdk.model.IDCardParams;
import com.baidu.ocr.sdk.model.IDCardResult;
import com.baidu.ocr.sdk.model.Word;
import com.baidu.ocr.ui.camera.CameraActivity;
import com.xdja.aircert1.R;
import java.io.File;

public class IdCardActivity
extends AppCompatActivity
implements View.OnClickListener {
    private String name;
    private String sex;
    private String birthDay;
    private String nation;
    private String address;
    private String idNum;
    private String issue;
    private String validDate;
    public static final int REQUEST_CODE_CAMERA = 102;
    private static final int REQUEST_CODE_PICK_IMAGE = 100;
    private static final int PERMISSIONS_REQUEST_CAMERA = 800;
    private static final int PERMISSIONS_EXTERNAL_STORAGE = 801;
    private Button mannulInputBtn;
    private Button scanInputBtn;
    private Button nextBtn;
    private EditText usernameEt;
    private EditText idcardEt;
    private TextView tipTv;
    private String username = "";
    private String idnumber = "";
    private AlertDialog.Builder alertDialog;
    private boolean mannulInput = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_idcard_layout);
        this.alertDialog = new AlertDialog.Builder((Context)this);
        this.findView();
        this.addListener();
        this.initOCRSDK();
        if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") == -1) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.CAMERA"}, (int)800);
            return;
        }
    }

    private void findView() {
        this.mannulInputBtn = (Button)this.findViewById(R.id.mannul_input_btn);
        this.scanInputBtn = (Button)this.findViewById(R.id.scan_input_btn);
        this.nextBtn = (Button)this.findViewById(R.id.next_btn);
        this.usernameEt = (EditText)this.findViewById(R.id.username_et);
        this.idcardEt = (EditText)this.findViewById(R.id.idnumber_et);
        this.tipTv = (TextView)this.findViewById(R.id.tip_tv);
    }

    private void addListener() {
        this.mannulInputBtn.setOnClickListener((View.OnClickListener)this);
        this.scanInputBtn.setOnClickListener((View.OnClickListener)this);
        this.nextBtn.setOnClickListener((View.OnClickListener)this);
    }

    private void initOCRSDK() {
        OCR.getInstance().initAccessToken((OnResultListener)new OnResultListener<AccessToken>(){

            public void onResult(AccessToken result) {
                String token = result.getAccessToken();
            }

            public void onError(OCRError error) {
                IdCardActivity.this.displayToastTip(error.getMessage());
            }
        }, this.getApplicationContext());
    }

    public void onClick(View v) {
        if (v == this.mannulInputBtn) {
            this.usernameEt.setVisibility(this.usernameEt.getVisibility() == 8 ? 0 : 8);
            this.idcardEt.setVisibility(this.idcardEt.getVisibility() == 8 ? 0 : 8);
            this.mannulInput = this.usernameEt.getVisibility() == 0;
            this.scanInputBtn.setVisibility(this.mannulInput ? 8 : 0);
            this.nextBtn.setVisibility(this.mannulInput ? 0 : 8);
        } else if (v == this.scanInputBtn) {
            AccessToken accessToken = OCR.getInstance().getAccessToken();
            if (accessToken == null || TextUtils.isEmpty((CharSequence)accessToken.getAccessToken())) {
                this.initOCRSDK();
                Toast.makeText((Context)this, (CharSequence)"OCR token \u6b63\u5728\u62c9\u53d6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5 ", (int)0).show();
                return;
            }
            Intent intent = new Intent((Context)this, CameraActivity.class);
            intent.putExtra("outputFilePath", FileUtil.getSaveFile((Context)this.getApplication()).getAbsolutePath());
            intent.putExtra("contentType", "IDCardFront");
            intent.putExtra("nativeToken", OCR.getInstance().getLicense());
            intent.putExtra("nativeEnable", true);
            this.startActivityForResult(intent, 102);
        } else if (v == this.nextBtn) {
            if (this.mannulInput) {
                this.username = this.usernameEt.getText().toString();
                this.idnumber = this.idcardEt.getText().toString();
            }
            if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") == -1) {
                ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.CAMERA"}, (int)800);
                return;
            }
            this.jumpToOnlineVerify();
        }
    }

    private void jumpToOnlineVerify() {
        if (TextUtils.isEmpty((CharSequence)this.username)) {
            Toast.makeText((Context)this, (CharSequence)"\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a", (int)0).show();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.idnumber)) {
            Toast.makeText((Context)this, (CharSequence)"\u8eab\u4efd\u8bc1\u4e0d\u80fd\u4e3a\u7a7a", (int)0).show();
            return;
        }
        Intent faceIntent = new Intent((Context)this, FaceOnlineVerifyActivity.class);
        faceIntent.putExtra("username", this.username);
        faceIntent.putExtra("idnumber", this.idnumber);
        this.startActivity(faceIntent);
    }

    private void recIDCard(final String idCardSide, final String filePath) {
        this.displayTip("\u8bc6\u522b\u4e2d...");
        IDCardParams param = new IDCardParams();
        param.setImageFile(new File(filePath));
        param.setIdCardSide(idCardSide);
        param.setDetectDirection(true);
        OCR.getInstance().recognizeIDCard(param, (OnResultListener)new OnResultListener<IDCardResult>(){

            public void onResult(IDCardResult result) {
                if (result != null) {
                    Word idnumberWord = result.getIdNumber();
                    Word nameWord = result.getName();
                    if (idnumberWord != null) {
                        IdCardActivity.this.idnumber = idnumberWord.getWords();
                    }
                    if (nameWord != null) {
                        IdCardActivity.this.username = nameWord.getWords();
                    }
                    Log.d((String)"idcard", (String)filePath);
                    File file = new File(filePath);
                    file.delete();
                    if (idCardSide.equals("front")) {
                        IdCardActivity.this.name = result.getName().getWords();
                        IdCardActivity.this.sex = result.getGender().getWords();
                        IdCardActivity.this.birthDay = result.getBirthday().getWords();
                        IdCardActivity.this.nation = result.getEthnic().getWords();
                        IdCardActivity.this.address = result.getAddress().getWords();
                        IdCardActivity.this.idNum = result.getIdNumber().getWords();
                        IdCardActivity.this.toBackSide();
                    } else if (idCardSide.equals("back")) {
                        Intent intent = new Intent();
                        intent.putExtra("name", IdCardActivity.this.name);
                        intent.putExtra("sex", IdCardActivity.this.sex);
                        intent.putExtra("birthDay", IdCardActivity.this.birthDay);
                        intent.putExtra("nation", IdCardActivity.this.nation);
                        intent.putExtra("address", IdCardActivity.this.address);
                        intent.putExtra("idNum", IdCardActivity.this.idNum);
                        intent.putExtra("issue", result.getIssueAuthority().getWords());
                        intent.putExtra("validDate", result.getExpiryDate().getWords());
                        intent.setAction("com.xdja.baidu_ocr");
                        intent.putExtra("filePath", filePath);
                        IdCardActivity.this.sendBroadcast(intent);
                    }
                }
                IdCardActivity.this.displayTip("");
            }

            public void onError(OCRError error) {
                IdCardActivity.this.alertText("\u8bc6\u522b\u7ed3\u679c", error.getMessage());
                IdCardActivity.this.displayTip("");
            }
        });
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
    }

    private void toBackSide() {
        AccessToken accessToken = OCR.getInstance().getAccessToken();
        if (accessToken == null || TextUtils.isEmpty((CharSequence)accessToken.getAccessToken())) {
            this.initOCRSDK();
            Toast.makeText((Context)this, (CharSequence)"OCR token \u6b63\u5728\u62c9\u53d6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5 ", (int)0).show();
            return;
        }
        Intent intent = new Intent((Context)this, CameraActivity.class);
        intent.putExtra("outputFilePath", FileUtil.getSaveFile((Context)this.getApplication()).getAbsolutePath());
        intent.putExtra("contentType", "IDCardBack");
        intent.putExtra("nativeToken", OCR.getInstance().getLicense());
        intent.putExtra("nativeEnable", true);
        this.startActivityForResult(intent, 102);
    }

    private void alertText(String title, String message) {
        this.alertDialog.setTitle((CharSequence)title).setMessage((CharSequence)message).setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                IdCardActivity.this.jumpToOnlineVerify();
            }
        }).show();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 102 && resultCode == -1 && data != null) {
            String contentType = data.getStringExtra("contentType");
            String filePath = FileUtil.getSaveFile(this.getApplicationContext()).getAbsolutePath();
            if (!TextUtils.isEmpty((CharSequence)contentType)) {
                if ("IDCardFront".equals(contentType)) {
                    this.recIDCard("front", filePath);
                } else if ("IDCardBack".equals(contentType)) {
                    this.recIDCard("back", filePath);
                }
            }
        }
    }

    private void displayTip(final String tip) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                IdCardActivity.this.tipTv.setText((CharSequence)tip);
            }
        });
    }

    private void displayToastTip(final String tip) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)IdCardActivity.this, (CharSequence)tip, (int)0).show();
            }
        });
    }
}

