/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.fp.utils;

import android.text.TextUtils;
import android.util.Base64;
import com.baidu.aip.fp.utils.FileBase64Encoder;
import com.baidu.aip.fp.utils.JsonHelper;
import com.baidu.aip.fp.utils.Util;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public class Base64RequestBody
extends RequestBody {
    private static final MediaType CONTENT_TYPE = MediaType.parse((String)"application/json;charset=utf-8");
    private static final String FORM_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#&!$(),~";
    private FileBase64Encoder encoder = new FileBase64Encoder();
    private Map<String, File> fileMap;
    private Map<String, String> stringParams;
    private String jsonParams;
    private String key;

    public void setKey(String key) {
        this.key = key;
    }

    public void setFileParams(Map<String, File> files) {
        this.fileMap = files;
    }

    public void setStringParams(Map<String, String> params) {
        this.stringParams = params;
    }

    public void setJsonParams(String jsonParams) {
        this.jsonParams = jsonParams;
    }

    public MediaType contentType() {
        return CONTENT_TYPE;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        int count = 0;
        StringBuilder sb = new StringBuilder();
        boolean debug = true;
        if (!TextUtils.isEmpty((CharSequence)this.jsonParams)) {
            sink.writeUtf8(this.jsonParams);
        }
        if (this.stringParams != null && this.stringParams.size() > 0) {
            String jsonStr = JsonHelper.toJSON(this.stringParams);
            sink.writeUtf8(jsonStr);
        }
        if (this.fileMap != null && this.fileMap.size() > 0) {
            if (count++ > 0) {
                sink.writeByte(38);
                sb.append("&");
            }
            String key = Util.canonicalize(this.key, FORM_ENCODE_SET, false, false);
            sink.writeUtf8(key);
            sink.writeByte(61);
            sb.append(key);
            sb.append('=');
            int num = 0;
            for (String k : this.fileMap.keySet()) {
                ++num;
                this.encoder.setInputFile(this.fileMap.get(k));
                File file = this.fileMap.get(k);
                byte[] buf = Base64RequestBody.readFile(file);
                byte[] base = Base64.encode((byte[])buf, (int)2);
                sink.writeUtf8(Util.canonicalize(new String(base), FORM_ENCODE_SET, false, false));
                sb.append(Util.canonicalize(new String(base), FORM_ENCODE_SET, false, false));
                if (num >= this.fileMap.size()) continue;
                sink.writeByte(44);
                sink.flush();
                sb.append(",");
            }
        }
        sink.close();
    }

    public static byte[] readFile(String file) throws IOException {
        return Base64RequestBody.readFile(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File file) throws IOException {
        try (RandomAccessFile f = new RandomAccessFile(file, "r");){
            long longlength = f.length();
            int length = (int)longlength;
            if ((long)length != longlength) {
                throw new IOException("File size >= 2 GB");
            }
            byte[] data = new byte[length];
            f.readFully(data);
            byte[] byArray = data;
            return byArray;
        }
    }
}

