/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.fp.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetManager;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.Uri;
import android.provider.MediaStore;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapUtil {
    static String TAG = "BitmapUtil";

    public static Bitmap getBitmap(String imageName, Context context) {
        try {
            AssetManager assetManager = context.getAssets();
            InputStream is = assetManager.open(imageName);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap rotateBitmap(Bitmap original, float degrees) {
        int width = original.getWidth();
        int height = original.getHeight();
        Matrix matrix = new Matrix();
        matrix.preRotate(degrees);
        return Bitmap.createBitmap((Bitmap)original, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
    }

    public static Bitmap getGalleryBmp(Context context, Uri uri) {
        Bitmap bitmap = null;
        try {
            bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)context.getContentResolver(), (Uri)uri);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public static String getRealPathFromURI(Context context, Uri contentURI) {
        String result;
        Cursor cursor = context.getContentResolver().query(contentURI, null, null, null, null);
        if (cursor == null) {
            result = contentURI.getPath();
        } else {
            cursor.moveToFirst();
            int idx = cursor.getColumnIndex("_data");
            result = cursor.getString(idx);
            cursor.close();
        }
        return result;
    }

    public static Bitmap cropOriginFace(Context context, Uri uri) {
        int rotation;
        Bitmap bitmap = BitmapUtil.getGalleryBmp(context, uri);
        String realPath = BitmapUtil.getRealPathFromURI(context, uri);
        if (bitmap == null) {
            bitmap = BitmapFactory.decodeFile((String)realPath);
        }
        if ((rotation = BitmapUtil.getOrientation(context, uri)) != 0) {
            bitmap = BitmapUtil.rotateBitmap(bitmap, rotation);
        }
        return bitmap;
    }

    public static Bitmap getFromGallery(Context context, Uri uri) {
        int rotation;
        Bitmap bitmap = BitmapUtil.getGalleryBmp(context, uri);
        String realPath = BitmapUtil.getRealPathFromURI(context, uri);
        if (bitmap == null) {
            bitmap = BitmapFactory.decodeFile((String)realPath);
        }
        if ((rotation = BitmapUtil.getOrientation(context, uri)) != 0) {
            bitmap = BitmapUtil.rotateBitmap(bitmap, rotation);
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOrientation(Context context, Uri photoUri) {
        int orientation = 0;
        try (Cursor cursor = null;){
            cursor = context.getContentResolver().query(photoUri, new String[]{"orientation"}, null, null, null);
            if (cursor != null) {
                if (cursor.getCount() != 1) {
                    int n = -1;
                    return n;
                }
                cursor.moveToFirst();
                orientation = cursor.getInt(0);
            }
        }
        return orientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBitmap(String outputPath, Bitmap bitmap) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outputPath);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Bitmap loadZoomBitmap(Context context, Bitmap bitmap) {
        int newHeight;
        int zoom;
        if (bitmap == null) {
            return null;
        }
        int bmpHeight = bitmap.getHeight();
        int bmpWidth = bitmap.getWidth();
        if (bmpWidth > 200) {
            zoom = bmpWidth / 200;
            newHeight = bmpHeight / zoom;
        } else {
            zoom = 1;
            newHeight = bmpHeight;
        }
        if (zoom <= 1) {
            return bitmap;
        }
        Bitmap bm = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)200, (int)newHeight, (boolean)true);
        if (bitmap != null) {
            bitmap.recycle();
        }
        return bm;
    }
}

