/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.fp.utils;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.baidu.aip.fp.APIService;
import com.baidu.aip.fp.OnResultListener;
import com.baidu.aip.fp.exception.FaceException;
import com.baidu.aip.fp.model.AccessToken;
import com.baidu.aip.fp.model.RequestParams;
import com.baidu.aip.fp.utils.AccessTokenParser;
import com.baidu.aip.fp.utils.Base64RequestBody;
import com.baidu.aip.fp.utils.Parser;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpUtil {
    private OkHttpClient client;
    private Handler handler;
    private static volatile HttpUtil instance;

    private HttpUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpUtil getInstance() {
        if (instance != null) return instance;
        Class<HttpUtil> clazz = HttpUtil.class;
        synchronized (HttpUtil.class) {
            if (instance != null) return instance;
            instance = new HttpUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init() {
        this.client = new OkHttpClient();
        this.handler = new Handler(Looper.getMainLooper());
    }

    public <T> void post(String path, RequestParams params, Parser<T> parser, OnResultListener<T> listener) {
        this.post(path, "images", params, parser, listener);
    }

    public <T> void post(String path, String key, RequestParams params, final Parser<T> parser, final OnResultListener<T> listener) {
        Base64RequestBody body = new Base64RequestBody();
        body.setKey(key);
        body.setFileParams(params.getFileParams());
        body.setStringParams(params.getStringParams());
        body.setJsonParams(params.getJsonParams());
        Request request = new Request.Builder().url(path).post((RequestBody)body).build();
        if (this.client == null) {
            HttpUtil.getInstance().release();
            HttpUtil.getInstance().init();
            if (this.client == null) {
                this.throwError(listener, -999, "okhttp inner error");
                return;
            }
        }
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
                HttpUtil.this.throwError(listener, 10000, "network request error");
            }

            public void onResponse(Call call, Response response) throws IOException {
                String responseString = response.body().string();
                try {
                    final Object result = parser.parse(responseString);
                    HttpUtil.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            listener.onResult(result);
                        }
                    });
                }
                catch (FaceException error) {
                    error.printStackTrace();
                    HttpUtil.this.throwError(listener, -1, error.toString());
                    HttpUtil.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            listener.onError(error);
                        }
                    });
                }
            }
        });
    }

    public void getAccessToken(final OnResultListener<AccessToken> listener, String url, String param) {
        final AccessTokenParser accessTokenParser = new AccessTokenParser();
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"text/html"), (String)param);
        Request request = new Request.Builder().url(url).post(body).build();
        Call call = this.client.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
                HttpUtil.this.throwError(listener, 10000, "network request error");
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response == null || response.body() == null || TextUtils.isEmpty((CharSequence)response.toString())) {
                    HttpUtil.this.throwError(listener, 110, "token is parse error, please rerequest token");
                }
                try {
                    final AccessToken accessToken = (AccessToken)accessTokenParser.parse(response.body().string());
                    if (accessToken != null) {
                        APIService.getInstance().setAccessToken(accessToken.getAccessToken());
                        HttpUtil.this.handler.post(new Runnable(){

                            @Override
                            public void run() {
                                listener.onResult(accessToken);
                            }
                        });
                    } else {
                        HttpUtil.this.throwError(listener, 110, "token is parse error, please rerequest token");
                    }
                }
                catch (FaceException error) {
                    error.printStackTrace();
                    HttpUtil.this.throwError(listener, 110, "token is parse error, please rerequest token");
                }
            }
        });
    }

    private void throwError(final OnResultListener listener, int errorCode, String msg) {
        final FaceException error = new FaceException(errorCode, msg);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                listener.onError(error);
            }
        });
    }

    public void release() {
        this.client = null;
        this.handler = null;
    }
}

