/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.fp.utils;

import android.util.Log;
import com.baidu.aip.fp.exception.FaceException;
import com.baidu.aip.fp.model.OnlineFaceliveResult;
import com.baidu.aip.fp.utils.Parser;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OnlineLivenessResultParser
implements Parser<OnlineFaceliveResult> {
    @Override
    public OnlineFaceliveResult parse(String json) throws FaceException {
        Log.i((String)"PoliceCheckResultParser", (String)("OnlineFaceliveResult->" + json));
        try {
            JSONObject jsonObject = new JSONObject(json);
            if (jsonObject.has("error_code")) {
                FaceException error = new FaceException(jsonObject.optInt("error_code"), jsonObject.optString("error_msg"));
                throw error;
            }
            OnlineFaceliveResult livenessResult = new OnlineFaceliveResult();
            livenessResult.setLogId(jsonObject.optLong("log_id"));
            livenessResult.setJsonRes(json);
            JSONArray results = jsonObject.optJSONArray("result");
            if (results != null) {
                for (int i = 0; i < results.length(); ++i) {
                    JSONObject livenessJOSNObject = results.optJSONObject(i);
                    if (livenessJOSNObject == null) continue;
                    double faceliveness = livenessJOSNObject.optDouble("faceliveness");
                    livenessResult.getFacelivenessValue().add(faceliveness);
                }
            }
            return livenessResult;
        }
        catch (JSONException e) {
            e.printStackTrace();
            FaceException error = new FaceException(11000, "Json parse error:" + json, e);
            throw error;
        }
    }
}

