/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.fp;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import com.baidu.aip.fp.Config;
import com.baidu.aip.fp.utils.FaceCropper;
import com.baidu.idl.face.platform.FaceConfig;
import com.baidu.idl.face.platform.FaceSDKManager;
import com.baidu.idl.face.platform.FaceStatusEnum;
import com.baidu.idl.face.platform.LivenessTypeEnum;
import com.baidu.idl.face.platform.ui.FaceLivenessActivity;
import com.baidu.idl.face.platform.utils.Base64Utils;
import com.baidu.idl.facesdk.FaceInfo;
import com.baidu.idl.facesdk.FaceSDK;
import com.baidu.idl.facesdk.FaceTracker;
import com.baidu.ocr.ui.camera.PermissionCallback;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class OfflineFaceLivenessActivity
extends FaceLivenessActivity {
    private String bestImagePath;
    private AlertDialog.Builder alertDialog;
    private static final int REQUEST_CODE_PICK_IMAGE = 100;
    private static final int PERMISSIONS_REQUEST_CAMERA = 800;
    private static final int PERMISSIONS_EXTERNAL_STORAGE = 801;
    private PermissionCallback permissionCallback = new PermissionCallback(){

        public boolean onRequestPermission() {
            ActivityCompat.requestPermissions((Activity)OfflineFaceLivenessActivity.this, (String[])new String[]{"android.permission.CAMERA"}, (int)800);
            return false;
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initFaceSDK();
        this.alertDialog = new AlertDialog.Builder((Context)this);
    }

    private void initFaceSDK() {
        FaceSDKManager.getInstance().initialize((Context)this, Config.licenseID, Config.licenseFileName);
        this.setFaceConfig();
    }

    private void setFaceConfig() {
        FaceConfig config = FaceSDKManager.getInstance().getFaceConfig();
        ArrayList<LivenessTypeEnum> livenessList = new ArrayList<LivenessTypeEnum>();
        livenessList.add(LivenessTypeEnum.Mouth);
        livenessList.add(LivenessTypeEnum.Eye);
        config.setLivenessTypeList(livenessList);
        config.setLivenessRandom(true);
        config.setBlurnessValue(0.5f);
        config.setBrightnessValue(40.0f);
        config.setCropFaceValue(400);
        config.setHeadPitchValue(10);
        config.setHeadRollValue(10);
        config.setHeadYawValue(10);
        config.setMinFaceSize(200);
        config.setNotFaceValue(0.6f);
        config.setOcclusionValue(0.5f);
        config.setCheckFaceQuality(true);
        config.setSound(true);
        FaceSDKManager.getInstance().setFaceConfig(config);
    }

    public void onLivenessCompletion(FaceStatusEnum status, String message, HashMap<String, String> base64ImageMap) {
        super.onLivenessCompletion(status, message, base64ImageMap);
        if (status == FaceStatusEnum.OK && this.mIsCompletion) {
            this.saveImage(base64ImageMap);
            this.alertText("\u68c0\u6d4b\u7ed3\u679c", "\u6d3b\u4f53\u68c0\u6d4b\u6210\u529f");
        } else if (status == FaceStatusEnum.Error_DetectTimeout || status == FaceStatusEnum.Error_LivenessTimeout || status == FaceStatusEnum.Error_Timeout) {
            this.alertText("\u68c0\u6d4b\u7ed3\u679c", "\u6d3b\u4f53\u68c0\u6d4b\u91c7\u96c6\u8d85\u65f6");
        }
    }

    public void finish() {
        super.finish();
    }

    private void saveImage(HashMap<String, String> imageMap) {
        String bestimageBase64 = imageMap.get("bestImage0");
        Bitmap bmp = OfflineFaceLivenessActivity.base64ToBitmap(bestimageBase64);
        try {
            File file = File.createTempFile("face", ".jpg");
            FileOutputStream outputStream = new FileOutputStream(file);
            bmp.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)outputStream);
            outputStream.close();
            this.bestImagePath = file.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Bitmap detect(Bitmap bitmap) {
        FaceSDKManager.getInstance().getFaceTracker().clearTrackedFaces();
        int[] argb = new int[bitmap.getHeight() * bitmap.getWidth()];
        bitmap.getPixels(argb, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
        int value = FaceSDKManager.getInstance().getFaceTracker().prepare_data_for_verify(argb, bitmap.getHeight(), bitmap.getWidth(), FaceSDK.ImgType.ARGB.ordinal(), FaceTracker.ActionType.RECOGNIZE.ordinal());
        FaceInfo[] faces = FaceSDKManager.getInstance().getFaceTracker().get_TrackedFaceInfo();
        Log.i((String)"detect", (String)(value + " faces->" + faces));
        if (faces != null) {
            int bottom;
            FaceInfo faceInfo = faces[0];
            int faceWith = faceInfo.mWidth;
            int centerX = faceInfo.mCenter_x;
            int centerY = faceInfo.mCenter_y;
            int left = centerX - faceWith / 2;
            int top = centerY - faceWith / 2;
            int right = centerX + faceWith / 2;
            if (left < 0) {
                left = 0;
            }
            if (right > bitmap.getWidth()) {
                right = bitmap.getWidth();
            }
            if (top < 0) {
                top = 0;
            }
            if ((bottom = centerY + faceWith / 2) > bitmap.getHeight()) {
                bottom = bitmap.getHeight();
            }
            Rect cropRect = new Rect(left, top, right, bottom);
            int[] cropArgb = FaceCropper.crop(argb, bitmap.getWidth(), cropRect);
            Bitmap cropBitmap = Bitmap.createBitmap((int[])cropArgb, (int)0, (int)cropRect.width(), (int)cropRect.width(), (int)cropRect.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            FaceSDKManager.getInstance().getFaceTracker().clearTrackedFaces();
            return cropBitmap;
        }
        return bitmap;
    }

    private void alertText(final String title, final String message) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                OfflineFaceLivenessActivity.this.alertDialog.setTitle((CharSequence)title).setMessage((CharSequence)message).setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        Intent intent = new Intent();
                        intent.putExtra("bestimage_path", OfflineFaceLivenessActivity.this.bestImagePath);
                        OfflineFaceLivenessActivity.this.setResult(-1, intent);
                        OfflineFaceLivenessActivity.this.finish();
                    }
                }).show();
            }
        });
    }

    private static Bitmap base64ToBitmap(String base64Data) {
        byte[] bytes = Base64Utils.decode((String)base64Data, (int)2);
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }
}

