/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.fp;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.baidu.aip.fp.APIService;
import com.baidu.aip.fp.Config;
import com.baidu.aip.fp.OfflineFaceLivenessActivity;
import com.baidu.aip.fp.OnResultListener;
import com.baidu.aip.fp.exception.FaceException;
import com.baidu.aip.fp.model.AccessToken;
import com.baidu.aip.fp.model.LivenessVsIdcardResult;
import com.xdja.aircert1.R;
import java.io.File;

public class FaceOnlineVerifyActivity
extends AppCompatActivity
implements View.OnClickListener {
    public static final int OFFLINE_FACE_LIVENESS_REQUEST = 100;
    private String username;
    private String idnumber;
    private TextView resultTipTV;
    private TextView scoreTV;
    private ImageView avatarIv;
    private Button retBtn;
    private String filePath;
    private boolean policeVerifyFinish = false;
    private boolean waitAccesstoken = true;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_face_online_check);
        Intent intent = this.getIntent();
        if (intent != null) {
            this.username = intent.getStringExtra("username");
            this.idnumber = intent.getStringExtra("idnumber");
        }
        this.resultTipTV = (TextView)this.findViewById(R.id.result_tip_tv);
        this.scoreTV = (TextView)this.findViewById(R.id.score_tv);
        this.avatarIv = (ImageView)this.findViewById(R.id.avatar_iv);
        this.retBtn = (Button)this.findViewById(R.id.retry_btn);
        this.retBtn.setOnClickListener((View.OnClickListener)this);
        this.initAccessToken();
        Intent faceLivenessintent = new Intent((Context)this, OfflineFaceLivenessActivity.class);
        this.startActivityForResult(faceLivenessintent, 100);
    }

    public void onClick(View v) {
        if (v == this.retBtn) {
            Intent faceLivenessintent = new Intent((Context)this, OfflineFaceLivenessActivity.class);
            this.startActivityForResult(faceLivenessintent, 100);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100 && data != null) {
            this.filePath = data.getStringExtra("bestimage_path");
            if (TextUtils.isEmpty((CharSequence)this.filePath)) {
                Toast.makeText((Context)this, (CharSequence)"\u79bb\u7ebf\u6d3b\u4f53\u56fe\u7247\u6ca1\u627e\u5230", (int)0).show();
                this.finish();
                return;
            }
            Bitmap bitmap = BitmapFactory.decodeFile((String)this.filePath);
            this.policeVerify(this.filePath);
        } else {
            this.finish();
        }
    }

    private void initAccessToken() {
        this.displayTip(this.resultTipTV, "\u52a0\u8f7d\u4e2d");
        APIService.getInstance().init(this.getApplicationContext());
        APIService.getInstance().initAccessTokenWithAkSk(new OnResultListener<AccessToken>(){

            @Override
            public void onResult(AccessToken result) {
                if (result != null && !TextUtils.isEmpty((CharSequence)result.getAccessToken())) {
                    FaceOnlineVerifyActivity.this.waitAccesstoken = false;
                    FaceOnlineVerifyActivity.this.policeVerify(FaceOnlineVerifyActivity.this.filePath);
                } else if (result != null) {
                    FaceOnlineVerifyActivity.this.displayTip(FaceOnlineVerifyActivity.this.resultTipTV, "\u5728\u7ebf\u6d3b\u4f53token\u83b7\u53d6\u5931\u8d25");
                    FaceOnlineVerifyActivity.this.retBtn.setVisibility(0);
                } else {
                    FaceOnlineVerifyActivity.this.displayTip(FaceOnlineVerifyActivity.this.resultTipTV, "\u5728\u7ebf\u6d3b\u4f53token\u83b7\u53d6\u5931\u8d25");
                    FaceOnlineVerifyActivity.this.retBtn.setVisibility(0);
                }
            }

            @Override
            public void onError(FaceException error) {
                FaceOnlineVerifyActivity.this.displayTip(FaceOnlineVerifyActivity.this.resultTipTV, "\u5728\u7ebf\u6d3b\u4f53token\u83b7\u53d6\u5931\u8d25");
                FaceOnlineVerifyActivity.this.retBtn.setVisibility(0);
            }
        }, Config.apiKey, Config.secretKey);
    }

    private void policeVerify(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath) || this.waitAccesstoken) {
            return;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            return;
        }
        this.displayTip(this.resultTipTV, "\u516c\u5b89\u8eab\u4efd\u6838\u5b9e\u4e2d...");
        APIService.getInstance().policeVerify(this.username, this.idnumber, filePath, new OnResultListener<LivenessVsIdcardResult>(){

            @Override
            public void onResult(LivenessVsIdcardResult result) {
                if (result != null && result.getScore() >= 80.0) {
                    FaceOnlineVerifyActivity.this.delete();
                    FaceOnlineVerifyActivity.this.displayTip(FaceOnlineVerifyActivity.this.resultTipTV, "\u6838\u8eab\u6210\u529f");
                    FaceOnlineVerifyActivity.this.displayTip(FaceOnlineVerifyActivity.this.scoreTV, "\u516c\u5b89\u9a8c\u8bc1\u5206\u6570\uff1a" + result.getScore());
                } else {
                    FaceOnlineVerifyActivity.this.displayTip(FaceOnlineVerifyActivity.this.resultTipTV, "\u6838\u8eab\u5931\u8d25");
                    FaceOnlineVerifyActivity.this.displayTip(FaceOnlineVerifyActivity.this.scoreTV, "\u516c\u5b89\u9a8c\u8bc1\u5206\u6570\u8fc7\u4f4e\uff1a" + result.getScore());
                    FaceOnlineVerifyActivity.this.retBtn.setVisibility(0);
                }
            }

            @Override
            public void onError(FaceException error) {
                FaceOnlineVerifyActivity.this.delete();
                Toast.makeText((Context)FaceOnlineVerifyActivity.this, (CharSequence)("\u516c\u5b89\u8eab\u4efd\u6838\u5b9e\u5931\u8d25:" + error.getMessage()), (int)0).show();
                FaceOnlineVerifyActivity.this.retBtn.setVisibility(0);
            }
        });
    }

    private void delete() {
        File file = new File(this.filePath);
        if (file.exists()) {
            file.delete();
        }
    }

    private void displayTip(final TextView textView, final String tip) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (textView != null) {
                    textView.setText((CharSequence)tip);
                }
            }
        });
    }
}

