/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.fp.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.baidu.aip.fp.utils.Util;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.UUID;

public class DeviceUtil {
    private static final int REQUEST_READ_PHONE_STATE = 0;

    public static String getVersionName(Context context) {
        String versionName = "";
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            versionName = packInfo.versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return versionName;
    }

    public static String getDeviceId(Context context) {
        SharedPreferences sp = context.getSharedPreferences("ocr_sdk_uuid", 0);
        String uuid = sp.getString("uuid", "");
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            uuid = UUID.randomUUID().toString();
            SharedPreferences.Editor editor = sp.edit();
            editor.putString("uuid", uuid);
            editor.commit();
        }
        if (uuid == null) {
            return "";
        }
        return uuid;
    }

    public static String getBuildVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getBuildBoard() {
        return Build.BOARD;
    }

    public static String getDeviceInfo(Context context) {
        StringBuilder sb = new StringBuilder();
        sb.append("Android#");
        sb.append(DeviceUtil.getBuildVersion()).append("#");
        sb.append(DeviceUtil.getBuildBoard()).append("#");
        sb.append(DeviceUtil.getDeviceId(context));
        return sb.toString();
    }

    public static String getImei(Context context) {
        int permissionCheck = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE");
        String deviceId = null;
        if (permissionCheck == 0) {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            deviceId = tm.getDeviceId();
        } else {
            deviceId = DeviceUtil.getMac();
            if (TextUtils.isEmpty((CharSequence)deviceId)) {
                deviceId = DeviceUtil.getDeviceModel();
            }
        }
        String strMd5 = Util.md5(deviceId);
        String mdtDeviceId = "";
        mdtDeviceId = strMd5.length() > 8 ? strMd5.substring(0, 8) : strMd5;
        return mdtDeviceId;
    }

    public static String getDeviceModel() {
        return Build.MODEL + Build.VERSION.SDK_INT;
    }

    public static String getMac() {
        String str = "";
        String macSerial = "";
        try {
            Process pp = Runtime.getRuntime().exec("cat /sys/class/net/wlan0/address ");
            InputStreamReader ir = new InputStreamReader(pp.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while (null != str) {
                str = input.readLine();
                if (str == null) continue;
                macSerial = str.trim();
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (macSerial == null || "".equals(macSerial)) {
            try {
                return DeviceUtil.loadFileAsString("/sys/class/net/eth0/address").toUpperCase().substring(0, 17);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return macSerial;
    }

    public static String loadFileAsString(String fileName) throws Exception {
        FileReader reader = new FileReader(fileName);
        String text = DeviceUtil.loadReaderAsString(reader);
        reader.close();
        return text;
    }

    public static String loadReaderAsString(Reader reader) throws Exception {
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[4096];
        int readLength = reader.read(buffer);
        while (readLength >= 0) {
            builder.append(buffer, 0, readLength);
            readLength = reader.read(buffer);
        }
        return builder.toString();
    }
}

