/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.fp;

import android.content.Context;
import android.util.Base64;
import com.baidu.aip.fp.OnResultListener;
import com.baidu.aip.fp.model.AccessToken;
import com.baidu.aip.fp.model.DynamicParams;
import com.baidu.aip.fp.model.LivenessVsIdcardResult;
import com.baidu.aip.fp.model.MatchModel;
import com.baidu.aip.fp.parser.RegResultParser;
import com.baidu.aip.fp.utils.Base64RequestBody;
import com.baidu.aip.fp.utils.HttpUtil;
import com.baidu.aip.fp.utils.PoliceCheckResultParser;
import java.io.File;

public class APIService {
    private static final String ACCESS_TOEKN_URL = "https://aip.baidubce.com/oauth/2.0/token?";
    private static final String LIVENESS_VS_IDCARD_URL = "https://aip.baidubce.com/rest/2.0/face/v3/person/verify";
    private static final String FACE_COMPARE = "https://aip.baidubce.com/rest/2.0/face/v3/match";
    private String accessToken;
    private static volatile APIService instance;

    private APIService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static APIService getInstance() {
        if (instance != null) return instance;
        Class<APIService> clazz = APIService.class;
        synchronized (APIService.class) {
            if (instance != null) return instance;
            instance = new APIService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(Context context) {
        HttpUtil.getInstance().init();
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void initAccessTokenWithAkSk(OnResultListener<AccessToken> listener, String ak, String sk) {
        StringBuilder sb = new StringBuilder();
        sb.append("client_id=").append(ak);
        sb.append("&client_secret=").append(sk);
        sb.append("&grant_type=client_credentials");
        HttpUtil.getInstance().getAccessToken(listener, ACCESS_TOEKN_URL, sb.toString());
    }

    public void policeVerify(String name, String idnumber, String file, OnResultListener<LivenessVsIdcardResult> listener) {
        DynamicParams params = new DynamicParams();
        String base64Img = "";
        try {
            byte[] buf = Base64RequestBody.readFile(file);
            base64Img = new String(Base64.encode((byte[])buf, (int)2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        params.setImgType("BASE64");
        params.setBase64Img(base64Img);
        params.putParam("name", name);
        params.putParam("id_card_number", idnumber);
        params.setQualityControl("NONE");
        params.setLivenessControl("NORMAL");
        PoliceCheckResultParser parser = new PoliceCheckResultParser();
        HttpUtil.getInstance().post(this.urlAppendCommonParams(LIVENESS_VS_IDCARD_URL), "image", params, parser, listener);
    }

    private String urlAppendCommonParams(String url) {
        StringBuilder sb = new StringBuilder(url);
        sb.append("?access_token=").append(this.accessToken);
        return sb.toString();
    }

    public void faceCompare(OnResultListener listener, File file1, File file2) {
        DynamicParams params = new DynamicParams();
        String jsonParams = MatchModel.getJson(file1, file2);
        params.setJsonParams(jsonParams);
        RegResultParser parser = new RegResultParser();
        HttpUtil.getInstance().post(this.urlAppendCommonParams(FACE_COMPARE), "images", params, parser, listener);
    }
}

