/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.fp;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.baidu.aip.fp.APIService;
import com.baidu.aip.fp.Config;
import com.baidu.aip.fp.OnResultListener;
import com.baidu.aip.fp.exception.FaceException;
import com.baidu.aip.fp.model.AccessToken;
import com.baidu.idl.face.platform.FaceConfig;
import com.baidu.idl.face.platform.FaceSDKManager;

public class DemoApplication
extends Application {
    private Handler handler = new Handler(Looper.getMainLooper());
    public static final float VALUE_BRIGHTNESS = 40.0f;
    public static final float VALUE_BLURNESS = 0.7f;
    public static final float VALUE_OCCLUSION = 0.6f;
    public static final int VALUE_HEAD_PITCH = 15;
    public static final int VALUE_HEAD_YAW = 15;
    public static final int VALUE_HEAD_ROLL = 15;
    public static final int VALUE_CROP_FACE_SIZE = 400;
    public static final int VALUE_MIN_FACE_SIZE = 120;
    public static final float VALUE_NOT_FACE_THRESHOLD = 0.6f;

    public void onCreate() {
        super.onCreate();
        DemoApplication.initLib(this);
        DemoApplication.initAccessToken(this);
    }

    public static void initAccessToken(Application application) {
        APIService.getInstance().init((Context)application);
        APIService.getInstance().initAccessTokenWithAkSk(new OnResultListener<AccessToken>(){

            @Override
            public void onResult(AccessToken result) {
                Log.i((String)"wtf", (String)("AccessToken->" + result.getAccessToken()));
            }

            @Override
            public void onError(FaceException error) {
                Log.e((String)"xx", (String)("AccessTokenError:" + error));
                error.printStackTrace();
            }
        }, Config.apiKey, Config.secretKey);
    }

    public static void initLib(Application application) {
        FaceSDKManager.getInstance().initialize((Context)application, Config.licenseID, Config.licenseFileName);
    }

    private void setFaceConfig() {
        FaceConfig config = FaceSDKManager.getInstance().getFaceConfig();
        config.setBlurnessValue(0.5f);
        config.setBrightnessValue(40.0f);
        config.setCropFaceValue(400);
        config.setHeadPitchValue(10);
        config.setHeadRollValue(10);
        config.setHeadYawValue(10);
        config.setMinFaceSize(200);
        config.setNotFaceValue(0.6f);
        config.setOcclusionValue(0.5f);
        config.setCheckFaceQuality(true);
        config.setFaceDecodeNumberOfThreads(2);
        FaceSDKManager.getInstance().setFaceConfig(config);
    }
}

