/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.fp.utils;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import com.baidu.aip.fp.utils.DeviceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageSaveUtil {
    public static final String SDCARD_PATH = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "facesharp" + File.separator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveBitmap(Context context, Bitmap image, String filename) {
        boolean saved = false;
        if (ImageSaveUtil.isMemeryOk(context)) {
            FileOutputStream fileOS = null;
            try {
                File file = new File(context.getFilesDir(), filename);
                if (file.exists()) {
                    file.delete();
                }
                fileOS = new FileOutputStream(file);
                Uri.fromFile((File)file);
                image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOS);
                file.getAbsolutePath();
                saved = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fileOS != null) {
                    try {
                        fileOS.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            ImageSaveUtil.saveBitmapToSDCard(context, image, filename);
            saved = true;
        }
        return saved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Uri saveBitmapToSDCard(Context context, Bitmap image, String filename) {
        Uri uri = null;
        FileOutputStream fileOS = null;
        String dir = SDCARD_PATH + DeviceUtil.getImei(context);
        try {
            File path = new File(dir);
            if (!path.exists()) {
                File filePhone = new File(context.getFilesDir(), filename);
                fileOS = new FileOutputStream(filePhone);
                uri = Uri.fromFile((File)filePhone);
                image.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)fileOS);
            } else {
                File file = new File(dir, filename);
                fileOS = new FileOutputStream(file);
                uri = Uri.fromFile((File)file);
                image.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)fileOS);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileOS != null) {
                try {
                    fileOS.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return uri;
    }

    public static boolean deleteBmpFromSDCard(Context context, String filename) {
        boolean deleted = false;
        try {
            File file = new File(context.getFilesDir(), filename);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String filePath = SDCARD_PATH + DeviceUtil.getImei(context) + File.separator + filename;
            File fileSdCard = new File(filePath);
            if (fileSdCard.isFile() && fileSdCard.exists()) {
                return fileSdCard.delete();
            }
            return deleted;
        }
        catch (Exception e) {
            e.printStackTrace();
            return deleted;
        }
    }

    public static String appendFaceImageFullPath(Context context, String uuid) {
        String fullPath = context.getFilesDir() + File.separator + uuid;
        File file = new File(fullPath);
        if (!file.exists()) {
            fullPath = SDCARD_PATH + DeviceUtil.getImei(context) + File.separator + uuid;
        }
        return fullPath;
    }

    public static boolean isSDCardOk(Context context) {
        String state = Environment.getExternalStorageState();
        boolean canWrite = "mounted".equals(state);
        return canWrite;
    }

    public static Bitmap rotateBitmap(int angle, Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        if (resizedBitmap != bitmap && !bitmap.isRecycled()) {
            bitmap.recycle();
            bitmap = null;
        }
        return resizedBitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveCameraBitmap(Context context, Bitmap image, String filename) {
        if (image == null) {
            return "";
        }
        String fullPath = "";
        FileOutputStream fileOS = null;
        try {
            if (ImageSaveUtil.isMemeryOk(context)) {
                File file = new File(context.getFilesDir(), filename);
                if (file.exists()) {
                    file.delete();
                }
                fileOS = new FileOutputStream(file);
                Uri.fromFile((File)file);
                image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOS);
                fullPath = file.getAbsolutePath();
            } else {
                String dir = SDCARD_PATH + DeviceUtil.getImei(context);
                File file = new File(dir, filename);
                if (file.exists()) {
                    file.delete();
                }
                fileOS = new FileOutputStream(file);
                Uri.fromFile((File)file);
                image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOS);
                fullPath = file.getAbsolutePath();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fileOS != null) {
                try {
                    fileOS.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return fullPath;
    }

    public static String loadCameraTempPath(Context context, String filename) {
        String filePath = context.getFilesDir() + File.separator + filename;
        File file = new File(filePath);
        if (!file.exists()) {
            filePath = SDCARD_PATH + DeviceUtil.getImei(context) + File.separator + filename;
        }
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap loadCameraBitmap(Context context, String filename) {
        Bitmap image = null;
        String filePath = context.getFilesDir() + File.separator + filename;
        File path = new File(filePath);
        if (!path.exists()) {
            filePath = SDCARD_PATH + DeviceUtil.getImei(context) + File.separator + filename;
        }
        File file = new File(filePath);
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            BitmapFactory.Options opts = new BitmapFactory.Options();
            opts.inPreferredConfig = Bitmap.Config.RGB_565;
            image = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)opts);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap loadBitmapFromPath(Context context, String filePath) {
        Bitmap image = null;
        File path = new File(filePath);
        if (!path.exists()) {
            return null;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(path);
            BitmapFactory.Options opts = new BitmapFactory.Options();
            opts.inPreferredConfig = Bitmap.Config.RGB_565;
            image = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)opts);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return image;
    }

    public static boolean isMemeryOk(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(mi);
        long total = mi.availMem;
        return total > 9999L;
    }

    public static boolean readSdCardPermission(Activity activity, int requestCode) {
        if (!ImageSaveUtil.isMemeryOk((Context)activity) && Build.VERSION.SDK_INT >= 23 && ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.READ_EXTERNAL_STORAGE") != 0) {
            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, (int)requestCode);
            return true;
        }
        return true;
    }
}

