package com.xdja.safeclient.certcreation;

import android.os.AsyncTask;
import android.text.TextUtils;

import com.xdja.safeclient.certcreation.bean.ServerAddress;
import com.xdja.safeclient.certcreation.databases.ServerSettingConfig;
import com.xdja.safeclient.certcreation.util.ModuleToast;

import org.apache.commons.net.telnet.TelnetClient;

import java.io.IOException;
import java.util.ArrayList;

/**
 * Created by Administrator on 2020/3/6 0006.
 */

public class ChooseAddress {


    public static ArrayList<ServerAddress> initList() {

        ServerSettingConfig serverSettingConfig = AppConfig.getInstance().getServerSettingConfig();

        String ip = serverSettingConfig.getIp();

        String port = serverSettingConfig.getPort();

        String[] ipArray = ip.split("\\|");
        String[] portArray = port.split("\\|");

        ArrayList<ServerAddress> serverAddressesList = new ArrayList<>();

        for (int count = 0; count < ipArray.length; count++) {
            serverAddressesList.add(count, new ServerAddress(ipArray[count], portArray[count]));
        }

        return serverAddressesList;

    }

    public static ArrayList<ServerAddress> initVHSMList() {

        ServerSettingConfig serverSettingConfig = AppConfig.getInstance().getServerSettingConfig();

        String ip = serverSettingConfig.getVhsm_ip();

        String port = serverSettingConfig.getVhsm_port();

        if (TextUtils.isEmpty(ip)
                || TextUtils.isEmpty(port)
                ) {
            return null;
        }

        String[] ipArray = ip.split("\\|");
        String[] portArray = port.split("\\|");

        ArrayList<ServerAddress> serverAddressesList = new ArrayList<>();

        for (int count = 0; count < ipArray.length; count++) {
            serverAddressesList.add(count, new ServerAddress(ipArray[count], portArray[count]));
        }

        return serverAddressesList;

    }


}
