package com.xdja.safeclient.certcreation.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.ConfigStep3Activity;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.bean.device.ContainerNum;
import com.xdja.safeclient.certcreation.config.AlgType;
import com.xdja.safeclient.certcreation.config.CertPermission;
import com.xdja.safeclient.certcreation.config.CertRule;
import com.xdja.safeclient.certcreation.config.CertType;
import com.xdja.safeclient.certcreation.databases.TableCertConfig;
import com.xdja.safeclient.certcreation.util.ConfigDialog;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.view.NoDoubleClickListener;

import java.util.List;

/**
 * Description:证书设备配置设备信息Adapter
 * Created by zjc on 2019/8/29 0008.
 */
public class CertConfigAdapter extends RecyclerView.Adapter<CertConfigAdapter.ViewHolder> {

    private Context context;

    private List<TableCertConfig> list;

    private boolean enableVHSM;

    ConfigListAdapter.OnItemClickListener onItemClickListener;


    public CertConfigAdapter(Context context, List<TableCertConfig> list, boolean enableVHSM) {
        this.context = context;
        this.list = list;
        this.enableVHSM = enableVHSM;
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(context).inflate(R.layout.item_device_detail, null));
    }

    @Override
    public void onBindViewHolder(final ViewHolder holder, final int position) {

        TableCertConfig certConfig = list.get(position);

//        final int position = certConfig.getPosition();

        holder.cardType.setText(certConfig.getCardType());

        if (holder.cardType.getText().toString().equals(ConfigStep3Activity.DEFAULT_CARD_TYPE_TEXT)) {
            holder.cardType.setTextColor(context.getResources().getColor(R.color.cert_creation_config_please_choose));
        } else {
            holder.cardType.setTextColor(context.getResources().getColor(R.color.black_333333));
        }

        holder.layoutCardType.setOnClickListener(new NoDoubleClickListener() {
            @Override
            public void onNoDoubleClick(View v) {

                if (enableVHSM) {
                        ConfigDialog.show(context, position, CardType.list);
                } else {
                    ConfigDialog.show(context, position, CardType.noVHSMList);
                }

            }
        });

        holder.containerNum.setText(String.valueOf(certConfig.getContainerNum()));

        holder.layoutContainerNum.setOnClickListener(new NoDoubleClickListener() {
            @Override
            public void onNoDoubleClick(View v) {
                ConfigDialog.show(context, position, ContainerNum.list);
            }
        });

        holder.algType.setText(certConfig.getAlgType());

        holder.layoutAlgType.setOnClickListener(new NoDoubleClickListener() {
            @Override
            public void onNoDoubleClick(View v) {
                ConfigDialog.show(context, position, AlgType.list);
            }
        });

        holder.certRule.setText(certConfig.getCertRule());

        holder.layoutCertRule.setOnClickListener(new NoDoubleClickListener() {
            @Override
            public void onNoDoubleClick(View v) {
                ConfigDialog.show(context, position, CertRule.list);
            }
        });

        holder.certType.setText(certConfig.getCertType());

        holder.layoutCertType.setOnClickListener(new NoDoubleClickListener() {
            @Override
            public void onNoDoubleClick(View v) {
                ConfigDialog.show(context, position, CertType.list);
            }
        });

        holder.certPermission.setText(certConfig.getCertPermission());

        holder.layoutCertPermission.setOnClickListener(new NoDoubleClickListener() {
            @Override
            public void onNoDoubleClick(View v) {
                ConfigDialog.show(context, position, CertPermission.list);
            }
        });


        if (position == 0) {
            holder.delete.setVisibility(View.INVISIBLE);
        } else {
            holder.delete.setVisibility(View.VISIBLE);
        }

        holder.delete.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                OttoUtil.postDeleteCertDetail(position);
            }
        });


    }

    @Override
    public int getItemCount() {
        return list.size();
    }


    class ViewHolder extends RecyclerView.ViewHolder {

        TextView cardType;

        View layoutCardType;

        TextView containerNum;

        View layoutContainerNum;

        TextView algType;

        View layoutAlgType;

        TextView certRule;

        View layoutCertRule;

        TextView certType;

        View layoutCertType;

        TextView certPermission;

        View layoutCertPermission;

        View delete;


        public ViewHolder(View itemView) {
            super(itemView);

            cardType = itemView.findViewById(R.id.card_type);

            layoutCardType = itemView.findViewById(R.id.layout_card_type);

            containerNum = itemView.findViewById(R.id.container_num);

            layoutContainerNum = itemView.findViewById(R.id.layout_container_num);

            algType = itemView.findViewById(R.id.alg_type);

            layoutAlgType = itemView.findViewById(R.id.layout_alg_type);

            certRule = itemView.findViewById(R.id.cert_rule);

            layoutCertRule = itemView.findViewById(R.id.layout_cert_rule);

            certType = itemView.findViewById(R.id.cert_type);

            layoutCertType = itemView.findViewById(R.id.layout_cert_type);

            certPermission = itemView.findViewById(R.id.cert_permission);

            layoutCertPermission = itemView.findViewById(R.id.layout_cert_permission);

            delete = itemView.findViewById(R.id.delete);


        }
    }

    public interface OnItemClickListener {
        void onItemSelected(int position);
    }

    public void setOnItemClickListener(ConfigListAdapter.OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }


}
